/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.component;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.component.SmelteryInputOutputTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

public class DrainTileEntity
extends SmelteryInputOutputTileEntity.SmelteryFluidIO
implements IDisplayFluidListener {
    private final IModelData modelData = new SinglePropertyData(IDisplayFluidListener.PROPERTY);
    private Fluid displayFluid = Fluids.field_204541_a;

    public DrainTileEntity() {
        super((TileEntityType)TinkerSmeltery.drain.get());
    }

    protected DrainTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void notifyDisplayFluidUpdated(Fluid fluid) {
        if (fluid != this.displayFluid) {
            this.displayFluid = fluid;
            this.modelData.setData(IDisplayFluidListener.PROPERTY, (Object)fluid);
            this.requestModelDataUpdate();
            assert (this.field_145850_b != null);
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 48);
        }
    }

    @Override
    public BlockPos getListenerPos() {
        return this.func_174877_v();
    }

    private void attachFluidListener() {
        BlockPos masterPos = this.getMasterPos();
        if (masterPos != null && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            TileEntityHelper.getTile(ISmelteryTankHandler.class, (IBlockReader)this.field_145850_b, (BlockPos)masterPos).ifPresent(te -> te.addDisplayListener(this));
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeMaster(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.attachFluidListener();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.writeMaster(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readMaster(pkt.func_148857_g());
        this.attachFluidListener();
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    public Fluid getDisplayFluid() {
        return this.displayFluid;
    }
}

