/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.controller;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.tileentity.controller.HeatingStructureTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.MultiAlloyingModule;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.SmelteryAlloyTank;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.SmelteryMultiblock;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

public class SmelteryTileEntity
extends HeatingStructureTileEntity {
    private static final int CAPACITY_PER_BLOCK = 1152;
    private static final int BLOCKS_PER_FUEL = 15;
    private final SmelteryAlloyTank alloyTank;
    private final MultiAlloyingModule alloyingModule;

    public SmelteryTileEntity() {
        super((TileEntityType<? extends HeatingStructureTileEntity>)((TileEntityType)TinkerSmeltery.smeltery.get()), (ITextComponent)TConstruct.makeTranslation("gui", "smeltery"));
        this.alloyTank = new SmelteryAlloyTank(this.tank);
        this.alloyingModule = new MultiAlloyingModule((MantleTileEntity)this, this.alloyTank);
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new SmelteryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new MeltingModuleInventory((MantleTileEntity)this, this.tank, () -> Config.COMMON.smelteryNuggetsPerOre.get());
    }

    @Override
    protected boolean isDebugItem(ItemStack stack) {
        return TinkerTags.Items.SMELTERY_DEBUG.func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.field_145850_b == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    int possibleTemp = this.fuelModule.findFuel(false);
                    this.alloyTank.setTemperature(possibleTemp);
                    if (!this.meltingInventory.canHeat(possibleTemp) && !this.alloyingModule.canAlloy()) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 2: {
                    if (!this.fuelModule.hasFuel()) break;
                    this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                    this.alloyingModule.doAlloy();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    BlockState state = this.func_195044_w();
                    if ((Boolean)state.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            int size = dx * dy * dz;
            this.tank.setCapacity(1152 * size);
            this.meltingInventory.resize(size, this.dropItem);
            this.fuelRate = 1 + (2 * (dx * dy) + 2 * (dy * dz) + dx * dz) / 15;
        }
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, Fluid fluid) {
        super.notifyFluidsChanged(type, fluid);
        if (type == ISmelteryTankHandler.FluidChange.ADDED) {
            this.alloyingModule.clearCachedRecipes();
        }
    }

    public MultiAlloyingModule getAlloyingModule() {
        return this.alloyingModule;
    }
}

