/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.table;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tables.client.inventory.BaseStationScreen;
import slimeknights.tconstruct.tables.client.inventory.SlotButtonItem;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.client.inventory.module.TinkerStationButtonsScreen;
import slimeknights.tconstruct.tables.inventory.table.tinkerstation.TinkerStationContainer;
import slimeknights.tconstruct.tables.inventory.table.tinkerstation.TinkerStationSlot;
import slimeknights.tconstruct.tables.network.TinkerStationSelectionPacket;
import slimeknights.tconstruct.tables.tileentity.table.TinkerStationTileEntity;

public class TinkerStationScreen
extends BaseStationScreen<TinkerStationTileEntity, TinkerStationContainer> {
    private static final ITextComponent COMPONENTS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.components");
    private static final ITextComponent MODIFIERS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.modifiers");
    private static final ITextComponent UPGRADES_TEXT = TConstruct.makeTranslation("gui", "tinker_station.upgrades");
    private static final ITextComponent TRAITS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.traits");
    private static final ITextComponent ASCII_ANVIL = new StringTextComponent("\n\n").func_240702_b_("       .\n").func_240702_b_("     /( _________\n").func_240702_b_("     |  >:=========`\n").func_240702_b_("     )(  \n").func_240702_b_("     \"\"").func_240699_a_(TextFormatting.DARK_GRAY);
    private static final int STILL_FILLED_X = 87;
    private static final int STILL_FILLED_Y = 62;
    private static final int STILL_FILLED_SPACING = 20;
    private static final ResourceLocation TINKER_STATION_TEXTURE = TConstruct.getResource("textures/gui/tinker_station.png");
    private static final ElementScreen ACTIVE_TEXT_FIELD = new ElementScreen(0, 210, 91, 12, 256, 256);
    private static final ElementScreen ITEM_COVER = new ElementScreen(176, 18, 80, 64);
    private static final ElementScreen SLOT_BACKGROUND = new ElementScreen(176, 0, 18, 18);
    private static final ElementScreen SLOT_BORDER = new ElementScreen(194, 0, 18, 18);
    private static final ElementScreen SLOT_SPACE_TOP = new ElementScreen(0, 176, 18, 2);
    private static final ElementScreen SLOT_SPACE_BOTTOM = new ElementScreen(0, 174, 18, 2);
    private static final ElementScreen PANEL_SPACE_LEFT = new ElementScreen(0, 174, 5, 4);
    private static final ElementScreen PANEL_SPACE_RIGHT = new ElementScreen(9, 174, 9, 4);
    private static final ElementScreen LEFT_BEAM = new ElementScreen(0, 180, 2, 7);
    private static final ElementScreen RIGHT_BEAM = new ElementScreen(131, 180, 2, 7);
    private static final ScalableElementScreen CENTER_BEAM = new ScalableElementScreen(2, 180, 129, 7);
    public static final int COLUMN_COUNT = 5;
    protected ElementScreen buttonDecorationTop = SLOT_SPACE_TOP;
    protected ElementScreen buttonDecorationBot = SLOT_SPACE_BOTTOM;
    protected ElementScreen panelDecorationL = PANEL_SPACE_LEFT;
    protected ElementScreen panelDecorationR = PANEL_SPACE_RIGHT;
    protected ElementScreen leftBeam = new ElementScreen(0, 0, 0, 0);
    protected ElementScreen rightBeam = new ElementScreen(0, 0, 0, 0);
    protected ScalableElementScreen centerBeam = new ScalableElementScreen(0, 0, 0, 0);
    @Nonnull
    private final StationSlotLayout defaultLayout;
    @Nonnull
    private StationSlotLayout currentLayout;
    protected InfoPanelScreen tinkerInfo;
    protected InfoPanelScreen modifierInfo;
    protected TinkerStationButtonsScreen buttonsScreen;
    private final int maxInputs;
    protected int activeInputs;

    public TinkerStationScreen(TinkerStationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.buttonsScreen = new TinkerStationButtonsScreen(this, (Container)container, playerInventory, title);
        this.addModule(this.buttonsScreen);
        this.tinkerInfo = new InfoPanelScreen(this, (Container)container, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen(this, (Container)container, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
        this.tinkerInfo.yOffset = 5;
        this.modifierInfo.yOffset = this.tinkerInfo.field_147000_g + 9;
        this.field_147000_g = 174;
        int max = 5;
        TinkerStationTileEntity te = (TinkerStationTileEntity)container.getTile();
        if (te != null) {
            max = te.getInputCount();
        }
        this.maxInputs = max;
        if (max > 3) {
            this.metal();
        } else {
            this.wood();
        }
        this.defaultLayout = te == null ? StationSlotLayout.EMPTY : StationSlotLayoutLoader.getInstance().get(Objects.requireNonNull(te.func_195044_w().func_177230_c().getRegistryName()));
        this.currentLayout = this.defaultLayout;
        this.activeInputs = Math.min(this.defaultLayout.getInputCount(), max);
        this.field_230711_n_ = false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_147009_r += 4;
        this.cornerY += 4;
        this.buttonsScreen.xOffset = -2;
        this.buttonsScreen.yOffset = this.centerBeam.h + this.buttonDecorationTop.h;
        this.tinkerInfo.xOffset = 2;
        this.tinkerInfo.yOffset = this.centerBeam.h + this.panelDecorationL.h;
        this.modifierInfo.xOffset = this.tinkerInfo.xOffset;
        this.modifierInfo.yOffset = this.tinkerInfo.yOffset + this.tinkerInfo.field_147000_g + 4;
        for (ModuleScreen module : this.modules) {
            module.field_147009_r += 4;
        }
        this.updateLayout();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void updateLayout() {
        int stillFilled = 0;
        for (int i = 0; i <= this.maxInputs; ++i) {
            Slot slot = ((TinkerStationContainer)this.field_147002_h).func_75139_a(i);
            LayoutSlot layoutSlot = this.currentLayout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slot.field_75223_e = 87 + 20 * stillFilled;
                slot.field_75221_f = 62;
                ++stillFilled;
                if (!(slot instanceof TinkerStationSlot)) continue;
                ((TinkerStationSlot)slot).deactivate();
                continue;
            }
            slot.field_75223_e = layoutSlot.getX();
            slot.field_75221_f = layoutSlot.getY();
            if (!(slot instanceof TinkerStationSlot)) continue;
            ((TinkerStationSlot)slot).activate(layoutSlot);
        }
        this.updateDisplay();
    }

    @Override
    public void updateDisplay() {
        if (this.tile == null) {
            return;
        }
        ItemStack toolStack = ((TinkerStationContainer)this.field_147002_h).getResult();
        ValidatedResult currentError = ((TinkerStationTileEntity)this.tile).getCurrentError();
        if (currentError.hasError()) {
            this.error(currentError.getMessage());
            return;
        }
        if (toolStack.func_190926_b()) {
            toolStack = ((TinkerStationContainer)this.field_147002_h).func_75139_a(0).func_75211_c();
        }
        if (TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)toolStack.func_77973_b())) {
            ITextComponent title;
            ToolStack tool = ToolStack.from(toolStack);
            if (toolStack.func_77973_b() instanceof ITinkerStationDisplay) {
                ITinkerStationDisplay display = (ITinkerStationDisplay)toolStack.func_77973_b();
                this.tinkerInfo.setCaption(display.getLocalizedName());
                this.tinkerInfo.setText(display.getStatInformation(tool, new ArrayList<ITextComponent>(), TooltipFlag.DETAILED));
            } else {
                this.tinkerInfo.setCaption(toolStack.func_200301_q());
                this.tinkerInfo.setText(new ITextComponent[0]);
            }
            ArrayList<ITextComponent> modifierNames = new ArrayList<ITextComponent>();
            ArrayList<ITextComponent> modifierInfo = new ArrayList<ITextComponent>();
            if (TinkerStationScreen.func_231172_r_()) {
                title = TRAITS_TEXT;
                Map<Modifier, Integer> upgrades = tool.getUpgrades().getModifiers().stream().collect(Collectors.toMap(ModifierEntry::getModifier, ModifierEntry::getLevel));
                for (ModifierEntry entry : tool.getModifierList()) {
                    int level;
                    Modifier mod = entry.getModifier();
                    if (!mod.shouldDisplay(true) || (level = entry.getLevel() - upgrades.getOrDefault(mod, 0)) <= 0) continue;
                    modifierNames.add(mod.getDisplayName(tool, level));
                    modifierInfo.add(mod.getDescription(tool, level));
                }
            } else {
                List<ModifierEntry> modifiers;
                if (TinkerStationScreen.func_231173_s_()) {
                    modifiers = tool.getUpgrades().getModifiers();
                    title = UPGRADES_TEXT;
                } else {
                    modifiers = tool.getModifierList();
                    title = MODIFIERS_TEXT;
                }
                for (ModifierEntry entry : modifiers) {
                    Modifier mod = entry.getModifier();
                    if (!mod.shouldDisplay(true)) continue;
                    int level = entry.getLevel();
                    modifierNames.add(mod.getDisplayName(tool, level));
                    modifierInfo.add(mod.getDescription(tool, level));
                }
            }
            this.modifierInfo.setCaption(title);
            this.modifierInfo.setText(modifierNames, modifierInfo);
        } else {
            this.tinkerInfo.setCaption(this.currentLayout.getDisplayName());
            this.tinkerInfo.setText(this.currentLayout.getDescription());
            StringTextComponent text = new StringTextComponent("");
            boolean hasComponents = false;
            for (int i = 0; i <= this.activeInputs; ++i) {
                LayoutSlot layout = this.currentLayout.getSlot(i);
                String key = layout.getTranslationKey();
                if (layout.isHidden() || key.isEmpty()) continue;
                hasComponents = true;
                StringTextComponent textComponent = new StringTextComponent(" * ");
                ItemStack slotStack = ((TinkerStationContainer)this.field_147002_h).func_75139_a(i).func_75211_c();
                if (!layout.isValid(slotStack)) {
                    textComponent.func_240699_a_(TextFormatting.RED);
                }
                textComponent.func_230529_a_((ITextComponent)new TranslationTextComponent(key)).func_240702_b_("\n");
                text.func_230529_a_((ITextComponent)textComponent);
            }
            if (hasComponents) {
                this.modifierInfo.setCaption(COMPONENTS_TEXT);
                this.modifierInfo.setText(new ITextComponent[]{text});
            } else {
                this.modifierInfo.setCaption(StringTextComponent.field_240750_d_);
                this.modifierInfo.setText(ASCII_ANVIL);
            }
        }
    }

    protected void drawContainerName(MatrixStack matrixStack) {
        this.field_230712_o_.func_243248_b(matrixStack, this.func_231171_q_(), 8.0f, 8.0f, 0x404040);
    }

    private static void renderPattern(MatrixStack matrices, Pattern pattern, int x, int y) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(pattern.getTexture());
        TinkerStationScreen.func_238470_a_((MatrixStack)matrices, (int)x, (int)y, (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    public static void renderIcon(MatrixStack matrices, LayoutIcon icon, int x, int y) {
        Pattern pattern = icon.getValue(Pattern.class);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (pattern != null) {
            minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            TinkerStationScreen.renderPattern(matrices, pattern, x, y);
            return;
        }
        ItemStack stack = icon.getValue(ItemStack.class);
        if (stack != null) {
            minecraft.func_175599_af().func_175042_a(stack, x, y);
        }
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        Slot slot;
        int i;
        this.drawBackground(matrices, TINKER_STATION_TEXTURE);
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 10.0f;
        float yOff = 22.0f;
        RenderSystem.translatef((float)10.0f, (float)22.0f, (float)0.0f);
        RenderSystem.scalef((float)3.7f, (float)3.7f, (float)1.0f);
        int logoX = (int)((float)this.cornerX / 3.7f);
        int logoY = (int)((float)this.cornerY / 3.7f);
        TinkerStationScreen.renderIcon(matrices, this.currentLayout.getIcon(), logoX, logoY);
        RenderSystem.scalef((float)0.27027026f, (float)0.27027026f, (float)1.0f);
        RenderSystem.translatef((float)-10.0f, (float)-22.0f, (float)0.0f);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(TINKER_STATION_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.82f);
        ITEM_COVER.draw(matrices, this.cornerX + 7, this.cornerY + 18);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        if (!this.currentLayout.getToolSlot().isHidden()) {
            Slot slot2 = ((TinkerStationContainer)this.field_147002_h).func_75139_a(0);
            SLOT_BACKGROUND.draw(matrices, x + this.cornerX + slot2.field_75223_e - 1, y + this.cornerY + slot2.field_75221_f - 1);
        }
        for (i = 0; i < this.activeInputs; ++i) {
            slot = ((TinkerStationContainer)this.field_147002_h).func_75139_a(i + 1);
            SLOT_BACKGROUND.draw(matrices, x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i <= this.maxInputs; ++i) {
            slot = ((TinkerStationContainer)this.field_147002_h).func_75139_a(i);
            if (!(slot instanceof TinkerStationSlot) || ((TinkerStationSlot)slot).isDormant() && !slot.func_75216_d()) continue;
            SLOT_BORDER.draw(matrices, x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        for (i = 0; i <= this.maxInputs; ++i) {
            Pattern icon;
            slot = ((TinkerStationContainer)this.field_147002_h).func_75139_a(i);
            if (slot.func_75216_d() || (icon = this.currentLayout.getSlot(i).getIcon()) == null) continue;
            TinkerStationScreen.renderPattern(matrices, icon, x + this.cornerX + slot.field_75223_e, y + this.cornerY + slot.field_75221_f);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(TINKER_STATION_TEXTURE);
        x = this.buttonsScreen.field_147003_i - this.leftBeam.w;
        y = this.cornerY;
        x += this.leftBeam.draw(matrices, x, y);
        x += this.centerBeam.drawScaledX(matrices, x, y, this.buttonsScreen.field_146999_f);
        this.rightBeam.draw(matrices, x, y);
        x = this.tinkerInfo.field_147003_i - this.leftBeam.w;
        x += this.leftBeam.draw(matrices, x, y);
        x += this.centerBeam.drawScaledX(matrices, x, y, this.tinkerInfo.field_146999_f);
        this.rightBeam.draw(matrices, x, y);
        for (Widget widget : this.buttonsScreen.getButtons()) {
            if (!(widget instanceof SlotButtonItem)) continue;
            SlotButtonItem button = (SlotButtonItem)widget;
            this.buttonDecorationTop.draw(matrices, button.field_230690_l_, button.field_230691_m_ - this.buttonDecorationTop.h);
            if (button.buttonId >= this.buttonsScreen.getButtons().size() - 5) continue;
            this.buttonDecorationBot.draw(matrices, button.field_230690_l_, button.field_230691_m_ + button.func_238483_d_());
        }
        this.panelDecorationL.draw(matrices, this.tinkerInfo.field_147003_i + 5, this.tinkerInfo.field_147009_r - this.panelDecorationL.h);
        this.panelDecorationR.draw(matrices, this.tinkerInfo.guiRight() - 5 - this.panelDecorationR.w, this.tinkerInfo.field_147009_r - this.panelDecorationR.h);
        this.panelDecorationL.draw(matrices, this.modifierInfo.field_147003_i + 5, this.modifierInfo.field_147009_r - this.panelDecorationL.h);
        this.panelDecorationR.draw(matrices, this.modifierInfo.guiRight() - 5 - this.panelDecorationR.w, this.modifierInfo.field_147009_r - this.panelDecorationR.h);
        RenderSystem.enableDepthTest();
        super.func_230450_a_(matrices, partialTicks, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    private static boolean needsDisplayUpdate(int keyCode) {
        if (keyCode == 340 || keyCode == 344) {
            return true;
        }
        if (Minecraft.field_142025_a) {
            return keyCode == 343 || keyCode == 347;
        }
        return keyCode == 341 || keyCode == 345;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public void func_238746_a_(MatrixStack matrixStack, Slot slotIn) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.func_75216_d()) {
            return;
        }
        super.func_238746_a_(matrixStack, slotIn);
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.func_75216_d()) {
            return false;
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    protected void wood() {
        this.tinkerInfo.wood();
        this.modifierInfo.wood();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(18, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(18, 0);
        this.buttonsScreen.shiftStyle(2);
        this.leftBeam = LEFT_BEAM;
        this.rightBeam = RIGHT_BEAM;
        this.centerBeam = CENTER_BEAM;
    }

    protected void metal() {
        this.tinkerInfo.metal();
        this.modifierInfo.metal();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w * 2, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w * 2, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(36, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(36, 0);
        this.buttonsScreen.shiftStyle(1);
        this.leftBeam = LEFT_BEAM.shift(0, TinkerStationScreen.LEFT_BEAM.h);
        this.rightBeam = RIGHT_BEAM.shift(0, TinkerStationScreen.RIGHT_BEAM.h);
        this.centerBeam = CENTER_BEAM.shift(0, TinkerStationScreen.CENTER_BEAM.h);
    }

    @Override
    public void error(ITextComponent message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption(StringTextComponent.field_240750_d_);
        this.modifierInfo.setText(StringTextComponent.field_240750_d_);
    }

    @Override
    public void warning(ITextComponent message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption(StringTextComponent.field_240750_d_);
        this.modifierInfo.setText(StringTextComponent.field_240750_d_);
    }

    public void onToolSelection(StationSlotLayout layout) {
        this.activeInputs = Math.min(layout.getInputCount(), this.maxInputs);
        this.currentLayout = layout;
        this.updateLayout();
        TinkerNetwork.getInstance().sendToServer(new TinkerStationSelectionPacket(layout.getName()));
    }

    @Nonnull
    public StationSlotLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }
}

