/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory.table.tinkerstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.inventory.BaseStationContainer;
import slimeknights.tconstruct.tables.inventory.table.LazyResultSlot;
import slimeknights.tconstruct.tables.inventory.table.tinkerstation.TinkerStationSlot;
import slimeknights.tconstruct.tables.tileentity.table.TinkerStationTileEntity;

public class TinkerStationContainer
extends BaseStationContainer<TinkerStationTileEntity> {
    private final List<Slot> inputSlots;
    private final LazyResultSlot resultSlot;

    public TinkerStationContainer(int id, PlayerInventory inv, @Nullable TinkerStationTileEntity tile) {
        super((ContainerType)TinkerTables.tinkerStationContainer.get(), id, inv, tile);
        if (tile != null) {
            tile.syncRecipe(inv.field_70458_d);
            this.inputSlots = new ArrayList<Slot>();
            this.inputSlots.add(this.func_75146_a(new TinkerStationSlot(tile, 0, 0, 0)));
            for (int index = 0; index < tile.func_70302_i_() - 1; ++index) {
                this.inputSlots.add(this.func_75146_a(new TinkerStationSlot(tile, index + 1, 0, 0)));
            }
            this.resultSlot = new LazyResultSlot(tile.getCraftingResult(), 124, 37);
            this.func_75146_a(this.resultSlot);
            this.setToolSelection(StationSlotLayoutLoader.getInstance().get(Objects.requireNonNull(tile.func_195044_w().func_177230_c().getRegistryName())));
        } else {
            this.resultSlot = null;
            this.inputSlots = Collections.emptyList();
        }
        this.addInventorySlots();
    }

    public TinkerStationContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (TinkerStationTileEntity)TinkerStationContainer.getTileEntityFromBuf((PacketBuffer)buf, TinkerStationTileEntity.class));
    }

    protected int getInventoryYOffset() {
        return 92;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.func_94530_a(stack, slot);
    }

    public void setToolSelection(StationSlotLayout layout) {
        assert (this.tile != null);
        int maxSize = ((TinkerStationTileEntity)this.tile).func_70302_i_();
        for (int i = 0; i < maxSize; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof TinkerStationSlot)) continue;
            TinkerStationSlot slotToolPart = (TinkerStationSlot)slot;
            LayoutSlot layoutSlot = layout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slotToolPart.deactivate();
                continue;
            }
            slotToolPart.activate(layoutSlot);
        }
    }

    public ItemStack getResult() {
        return this.resultSlot.func_75211_c();
    }

    public List<Slot> getInputSlots() {
        return this.inputSlots;
    }
}

