/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.chest;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.tconstruct.tables.inventory.TinkerChestContainer;

public abstract class ChestTileEntity
extends NamableTileEntity {
    private static final String KEY_ITEMS = "Items";
    private final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> capability;

    protected ChestTileEntity(TileEntityType<?> tileEntityTypeIn, String name, ItemStackHandler itemHandler) {
        super(tileEntityTypeIn, (ITextComponent)new TranslationTextComponent(name));
        this.itemHandler = itemHandler;
        this.capability = LazyOptional.of(() -> itemHandler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Nullable
    public Container createMenu(int menuId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TinkerChestContainer(menuId, playerInventory, this);
    }

    public boolean canInsert(PlayerEntity player, ItemStack heldItem) {
        return true;
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags = super.func_189515_b(tags);
        CompoundNBT handlerNBT = this.itemHandler.serializeNBT();
        tags.func_218657_a(KEY_ITEMS, (INBT)handlerNBT.func_150295_c(KEY_ITEMS, 10));
        return tags;
    }

    public void readInventory(CompoundNBT tags) {
        CompoundNBT handlerNBT = new CompoundNBT();
        handlerNBT.func_218657_a(KEY_ITEMS, (INBT)tags.func_150295_c(KEY_ITEMS, 10));
        this.itemHandler.deserializeNBT(handlerNBT);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tags) {
        super.func_230337_a_(blockState, tags);
        this.readInventory(tags);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

