/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.table;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.inventory.table.PartBuilderContainer;
import slimeknights.tconstruct.tables.tileentity.table.RetexturedTableTileEntity;
import slimeknights.tconstruct.tables.tileentity.table.crafting.LazyResultInventory;
import slimeknights.tconstruct.tables.tileentity.table.crafting.PartBuilderInventoryWrapper;

public class PartBuilderTileEntity
extends RetexturedTableTileEntity
implements LazyResultInventory.ILazyCrafter {
    public static final int MATERIAL_SLOT = 0;
    public static final int PATTERN_SLOT = 1;
    private final LazyResultInventory craftingResult;
    private final PartBuilderInventoryWrapper inventoryWrapper;
    @Nullable
    private Map<Pattern, IPartBuilderRecipe> recipes = null;
    @Nullable
    private List<Pattern> sortedButtons = null;
    private Pattern selectedPattern = null;
    private int selectedPatternIndex = -2;

    public PartBuilderTileEntity() {
        super((TileEntityType)TinkerTables.partBuilderTile.get(), "gui.tconstruct.part_builder", 3);
        this.itemHandler = new ConfigurableInvWrapperCapability((IInventory)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new PartBuilderInventoryWrapper(this);
        this.craftingResult = new LazyResultInventory(this);
    }

    protected Map<Pattern, IPartBuilderRecipe> getCurrentRecipes() {
        if (this.field_145850_b == null) {
            return Collections.emptyMap();
        }
        if (this.recipes == null) {
            if (this.func_70301_a(1).func_190926_b()) {
                this.recipes = Collections.emptyMap();
                this.sortedButtons = Collections.emptyList();
            } else {
                this.recipes = this.field_145850_b.func_199532_z().func_215366_a(RecipeTypes.PART_BUILDER).values().stream().filter(r -> r instanceof IPartBuilderRecipe).map(r -> (IPartBuilderRecipe)r).filter(r -> r.partialMatch(this.inventoryWrapper)).sorted(Comparator.comparing(IRecipe::func_199560_c)).collect(Collectors.toMap(IPartBuilderRecipe::getPattern, Function.identity(), (a, b) -> a));
                this.sortedButtons = this.recipes.values().stream().sorted((a, b) -> {
                    if (a.getCost() != b.getCost()) {
                        return Integer.compare(a.getCost(), b.getCost());
                    }
                    return a.getPattern().compareTo(b.getPattern());
                }).map(IPartBuilderRecipe::getPattern).collect(Collectors.toList());
            }
        }
        return this.recipes;
    }

    public List<Pattern> getSortedButtons() {
        if (this.field_145850_b == null) {
            return Collections.emptyList();
        }
        if (this.sortedButtons == null) {
            this.getCurrentRecipes();
        }
        return this.sortedButtons;
    }

    public int getSelectedIndex() {
        if (this.selectedPatternIndex == -2) {
            this.selectedPatternIndex = this.selectedPattern != null ? this.getSortedButtons().indexOf((Object)this.selectedPattern) : -1;
        }
        return this.selectedPatternIndex;
    }

    @Nullable
    public IPartBuilderRecipe getPartRecipe() {
        if (this.selectedPattern != null) {
            return this.getCurrentRecipes().get((Object)this.selectedPattern);
        }
        return null;
    }

    @Nullable
    public MaterialRecipe getMaterialRecipe() {
        return this.inventoryWrapper.getMaterial();
    }

    private void refresh(boolean refreshRecipeList) {
        if (refreshRecipeList) {
            this.recipes = null;
            this.sortedButtons = null;
        }
        this.selectedPatternIndex = -2;
        this.craftingResult.func_174888_l();
        if (refreshRecipeList && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.syncToRelevantPlayers(this::syncScreen);
        }
    }

    public void selectRecipe(@Nullable Pattern pattern) {
        this.selectedPattern = pattern != null && this.getCurrentRecipes().containsKey((Object)pattern) ? pattern : null;
        this.refresh(false);
    }

    public void selectRecipe(int index) {
        List<Pattern> list;
        this.selectedPattern = index < 0 ? null : (index < (list = this.getSortedButtons()).size() ? list.get(index) : null);
        this.refresh(false);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack original = this.func_70301_a(slot);
        super.func_70299_a(slot, stack);
        if (stack.func_77973_b() != original.func_77973_b()) {
            if (slot == 0) {
                this.inventoryWrapper.refreshMaterial();
            }
            this.refresh(true);
        } else if (slot == 0 && original.func_190916_E() != stack.func_190916_E()) {
            this.craftingResult.func_174888_l();
        }
    }

    @Nullable
    public Container createMenu(int menuId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new PartBuilderContainer(menuId, playerInventory, this);
    }

    @Override
    public ItemStack calcResult(@Nullable PlayerEntity player) {
        IPartBuilderRecipe recipe;
        if (this.field_145850_b != null && (recipe = this.getPartRecipe()) != null && recipe.func_77569_a((IInventory)this.inventoryWrapper, this.field_145850_b)) {
            return recipe.func_77572_b((IInventory)this.inventoryWrapper);
        }
        return ItemStack.field_190927_a;
    }

    private void shrinkSlot(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else {
                stack.func_190918_g(amount);
            }
        }
    }

    @Override
    public ItemStack onCraft(PlayerEntity player, ItemStack result, int amount) {
        if (amount == 0 || this.field_145850_b == null) {
            return ItemStack.field_190927_a;
        }
        IPartBuilderRecipe recipe = this.getPartRecipe();
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        result.func_77980_a(this.field_145850_b, player, amount);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)this.inventoryWrapper);
        this.playCraftSound(player);
        ItemStack leftover = recipe.getLeftover(this.inventoryWrapper);
        if (!leftover.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)leftover);
        }
        this.shrinkSlot(0, recipe.getItemsUsed(this.inventoryWrapper));
        this.shrinkSlot(1, 1);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.syncToRelevantPlayers(this::syncScreen);
        }
        return result;
    }

    public LazyResultInventory getCraftingResult() {
        return this.craftingResult;
    }

    public PartBuilderInventoryWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }
}

