/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.recipe.SingleItemInventory;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class AutosmeltModifier
extends SingleUseModifier {
    private final Cache<Item, Optional<FurnaceRecipe>> recipeCache = CacheBuilder.newBuilder().maximumSize(64L).build();
    private final SingleItemInventory inventory = new SingleItemInventory();

    public AutosmeltModifier() {
        super(12211228);
        RecipeCacheInvalidator.addReloadListener(client -> {
            if (!client) {
                this.recipeCache.invalidateAll();
            }
        });
    }

    private Optional<FurnaceRecipe> findRecipe(ItemStack stack, World world) {
        this.inventory.setStack(stack);
        return world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this.inventory, world);
    }

    @Nullable
    private FurnaceRecipe findCachedRecipe(ItemStack stack, World world) {
        if (stack.func_77942_o()) {
            return this.findRecipe(stack, world).orElse(null);
        }
        try {
            return ((Optional)this.recipeCache.get((Object)stack.func_77973_b(), () -> this.findRecipe(stack, world))).orElse(null);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private ItemStack smeltItem(ItemStack stack, World world) {
        if (TinkerTags.Items.AUTOSMELT_BLACKLIST.func_230235_a_((Object)stack.func_77973_b())) {
            return stack;
        }
        FurnaceRecipe recipe = this.findCachedRecipe(stack, world);
        if (recipe != null) {
            this.inventory.setStack(stack);
            ItemStack output = recipe.func_77572_b((IInventory)this.inventory);
            if (stack.func_190916_E() > 1) {
                output.func_190920_e(output.func_190916_E() * stack.func_190916_E());
            }
            return output;
        }
        return stack;
    }

    @Override
    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        ServerWorld world = context.func_202879_g();
        if (!generatedLoot.isEmpty()) {
            return generatedLoot.stream().map(arg_0 -> this.lambda$processLoot$2((World)world, arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        }
        return generatedLoot;
    }

    private /* synthetic */ ItemStack lambda$processLoot$2(World world, ItemStack stack) {
        return this.smeltItem(stack, world);
    }
}

