/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class StatOverrideModifier
extends SingleUseModifier {
    private static final ResourceLocation KEY_BONUS = TConstruct.getResource("override_bonus");
    private static final ResourceLocation KEY_MULTIPLY = TConstruct.getResource("override_multiplier");
    private static final ITextComponent LANG_BONUS = TConstruct.makeTranslation("modifier", "stat_override.bonuses").func_240699_a_(TextFormatting.UNDERLINE);
    private static final ITextComponent LANG_MULTIPLY = TConstruct.makeTranslation("modifier", "stat_override.multipliers").func_240699_a_(TextFormatting.UNDERLINE);

    public StatOverrideModifier() {
        super(-1);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(KEY_BONUS);
        tool.getPersistentData().remove(KEY_MULTIPLY);
    }

    private static void processStats(IModDataReadOnly persistentData, ResourceLocation key, StatConsumer consumer) {
        if (persistentData.contains(key, 10)) {
            CompoundNBT nbt = persistentData.getCompound(key);
            for (String name : nbt.func_150296_c()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryCreate(name);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                consumer.handle(stat, nbt.func_74760_g(name));
            }
        }
    }

    @Override
    public void addToolStats(Item item, ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        StatOverrideModifier.processStats(persistentData, KEY_BONUS, (stat, value) -> stat.applyBonus(builder, value));
        StatOverrideModifier.processStats(persistentData, KEY_MULTIPLY, (stat, value) -> {
            if (stat instanceof FloatToolStat) {
                ((FloatToolStat)stat).multiply(builder, value);
            }
        });
    }

    private static void addToTooltip(IModDataReadOnly persistentData, ResourceLocation groupKey, ITextComponent listStart, DecimalFormat format, Consumer<ITextComponent> consumer) {
        if (persistentData.contains(groupKey, 10)) {
            CompoundNBT stats = persistentData.getCompound(groupKey);
            boolean first = true;
            for (String key : stats.func_150296_c()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryCreate(key);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                if (first) {
                    consumer.accept(listStart);
                    first = false;
                }
                consumer.accept((ITextComponent)new StringTextComponent("* ").func_230529_a_((ITextComponent)stat.getPrefix()).func_240702_b_(format.format(stats.func_74760_g(key))));
            }
        }
    }

    @Override
    public List<ITextComponent> getDescriptionList(IModifierToolStack tool, int level) {
        List<ITextComponent> defaultList = this.getDescriptionList();
        MutableObject resultList = new MutableObject();
        Consumer<ITextComponent> consumer = text -> {
            ArrayList<ITextComponent> list = (ArrayList<ITextComponent>)resultList.getValue();
            if (list == null) {
                list = new ArrayList<ITextComponent>(defaultList);
                resultList.setValue(list);
            }
            list.add((ITextComponent)text);
        };
        ModDataNBT persistentData = tool.getPersistentData();
        StatOverrideModifier.addToTooltip(persistentData, KEY_BONUS, LANG_BONUS, Util.BONUS_FORMAT, consumer);
        StatOverrideModifier.addToTooltip(persistentData, KEY_MULTIPLY, LANG_MULTIPLY, Util.MULTIPLIER_FORMAT, consumer);
        List computedList = (List)resultList.getValue();
        if (computedList != null) {
            return computedList;
        }
        return defaultList;
    }

    private static boolean setStat(IModifierToolStack tool, ResourceLocation groupKey, IToolStat<?> stat, float value, float neutralValue) {
        CompoundNBT nbt;
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10)) {
            nbt = data.getCompound(groupKey);
        } else if (value != neutralValue) {
            nbt = new CompoundNBT();
            data.put(groupKey, (INBT)nbt);
        } else {
            return false;
        }
        String name = stat.getName().toString();
        if (value == neutralValue) {
            nbt.func_82580_o(name);
            if (nbt.func_150296_c().isEmpty()) {
                data.remove(groupKey);
                return false;
            }
        } else {
            nbt.func_74776_a(name, value);
        }
        return true;
    }

    private static float getStat(IModifierToolStack tool, ResourceLocation groupKey, IToolStat<?> stat, float defaultValue) {
        String name;
        CompoundNBT nbt;
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10) && (nbt = data.getCompound(groupKey)).func_150297_b(name = stat.getName().toString(), 5)) {
            return nbt.func_74760_g(name);
        }
        return defaultValue;
    }

    public boolean setBonus(IModifierToolStack tool, IToolStat<?> stat, float bonus) {
        return StatOverrideModifier.setStat(tool, KEY_BONUS, stat, bonus, 0.0f);
    }

    public boolean addBonus(IModifierToolStack tool, IToolStat<?> stat, float bonus) {
        if (bonus != 0.0f) {
            return this.setBonus(tool, stat, StatOverrideModifier.getStat(tool, KEY_BONUS, stat, 0.0f) + bonus);
        }
        return false;
    }

    public boolean setMultiplier(IModifierToolStack tool, FloatToolStat stat, float multiplier) {
        return StatOverrideModifier.setStat(tool, KEY_MULTIPLY, stat, multiplier, 1.0f);
    }

    public boolean multiply(IModifierToolStack tool, FloatToolStat stat, float value) {
        if (value != 1.0f) {
            return this.setMultiplier(tool, stat, StatOverrideModifier.getStat(tool, KEY_MULTIPLY, stat, 1.0f) * value);
        }
        return false;
    }

    @FunctionalInterface
    private static interface StatConsumer {
        public void handle(IToolStat<?> var1, float var2);
    }
}

