/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class RagingModifier
extends Modifier {
    private static final float LOWEST_HEALTH = 2.0f;
    private static final float HIGHEST_HEALTH = 10.0f;
    private static final float DAMAGE_PER_LEVEL = 4.0f;

    public RagingModifier() {
        super(0xB30000);
    }

    @Override
    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity attacker = context.getAttacker();
        float health = attacker.func_110143_aJ();
        float max = attacker.func_110138_aP();
        if (max < 10.0f) {
            health += 10.0f - max;
        }
        if (health <= 2.0f) {
            damage += (float)level * 4.0f;
        } else if (health < 10.0f) {
            damage += (float)level * 4.0f * (10.0f - health) / 8.0f;
        }
        return damage;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        this.addDamageTooltip(tool, level * 4, tooltip);
    }
}

