/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.harvest;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class BlastingModifier
extends IncrementalModifier {
    public BlastingModifier() {
        super(0x8A8A8A);
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            float blastResistance = event.getState().func_177230_c().func_149638_a();
            double boost = (double)level * Math.min(10.0, Math.pow(3.0, (6.0f - blastResistance) / 1.5f)) * (double)miningSpeedModifier;
            event.setNewSpeed(event.getNewSpeed() + (float)(boost *= (double)tool.getModifier(ToolStats.MINING_SPEED)));
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, (ITag<Item>)TinkerTags.Items.HARVEST, 10.0f * this.getScaledLevel(tool, level), tooltip);
    }
}

