/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.item.crafting.FireworkStarRecipe;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.BloodSlimeBlock;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeDirtBlock;
import slimeknights.tconstruct.world.block.SlimeFungusBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeNyliumBlock;
import slimeknights.tconstruct.world.block.SlimeSaplingBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.block.SlimeWartBlock;
import slimeknights.tconstruct.world.block.StickySlimeBlock;
import slimeknights.tconstruct.world.data.WorldRecipeProvider;
import slimeknights.tconstruct.world.entity.EarthSlimeEntity;
import slimeknights.tconstruct.world.entity.EnderSlimeEntity;
import slimeknights.tconstruct.world.entity.SkySlimeEntity;
import slimeknights.tconstruct.world.entity.SlimePlacementPredicate;
import slimeknights.tconstruct.world.entity.TerracubeEntity;
import slimeknights.tconstruct.world.item.SlimeGrassSeedItem;
import slimeknights.tconstruct.world.worldgen.trees.SlimeTree;

public final class TinkerWorld
extends TinkerModule {
    public static final ItemGroup TAB_WORLD = new SupplierItemGroup("tconstruct", "world", () -> new ItemStack(cobaltOre));
    static final Logger log = Util.getLogger("tinker_world");
    public static final PlantType SLIME_PLANT_TYPE = PlantType.get((String)"slime");
    private static final Item.Properties WORLD_PROPS = new Item.Properties().func_200916_a(TAB_WORLD);
    private static final Function<Block, ? extends BlockItem> DEFAULT_BLOCK_ITEM = b -> new BlockItem(b, WORLD_PROPS);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, WORLD_PROPS);
    private static final Item.Properties HEAD_PROPS = new Item.Properties().func_200916_a(TAB_WORLD).func_208103_a(Rarity.UNCOMMON);
    public static final Material SLIME_WOOD = new Material.Builder(MaterialColor.field_151667_k).func_200504_e().func_200506_i();
    public static final ItemObject<Block> cobaltOre = BLOCKS.register("cobalt_ore", () -> new Block(TinkerWorld.builder(Material.field_151576_e, MaterialColor.field_151655_K, ToolType.PICKAXE, SoundType.field_235592_N_).func_235861_h_().harvestLevel(2).func_200943_b(10.0f)), DEFAULT_BLOCK_ITEM);
    public static final ItemObject<Block> copperOre = BLOCKS.register("copper_ore", TinkerWorld.builder(Material.field_151576_e, ToolType.PICKAXE, SoundType.field_185851_d).func_235861_h_().harvestLevel(1).func_200948_a(3.0f, 3.0f), DEFAULT_BLOCK_ITEM);
    public static final EnumObject<SlimeType, SlimeBlock> slime = Util.make(() -> {
        Function<SlimeType, AbstractBlock.Properties> slimeProps = type -> TinkerWorld.builder(Material.field_151571_B, type.getMapColor(), NO_TOOL, SoundType.field_185859_l).func_200941_a(0.8f).func_200947_a(SoundType.field_185859_l).func_226896_b_();
        return new EnumObject.Builder(SlimeType.class).putDelegate((Enum)SlimeType.EARTH, Blocks.field_180399_cE.delegate).put((Enum)SlimeType.SKY, (Supplier)BLOCKS.register("sky_slime", () -> new StickySlimeBlock((AbstractBlock.Properties)slimeProps.apply(SlimeType.SKY), (state, other) -> true), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime", () -> new StickySlimeBlock(((AbstractBlock.Properties)slimeProps.apply(SlimeType.ICHOR)).func_235838_a_(s -> SlimeType.ICHOR.getLightLevel()), (state, other) -> other.func_177230_c() != state.func_177230_c()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ENDER, (Supplier)BLOCKS.register("ender_slime", () -> new StickySlimeBlock((AbstractBlock.Properties)slimeProps.apply(SlimeType.ENDER), (state, other) -> other.func_177230_c() == state.func_177230_c()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime", () -> new BloodSlimeBlock((AbstractBlock.Properties)slimeProps.apply(SlimeType.BLOOD)), TOOLTIP_BLOCK_ITEM)).build();
    });
    public static final EnumObject<SlimeType, CongealedSlimeBlock> congealedSlime = BLOCKS.registerEnum(SlimeType.values(), "congealed_slime", type -> new CongealedSlimeBlock(TinkerWorld.builder(Material.field_151571_B, type.getMapColor(), ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.5f).func_200941_a(0.5f).func_235838_a_(s -> type.getLightLevel())), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeType, Block> slimeDirt = Util.make(() -> {
        Function<SlimeType, MaterialColor> color = type -> {
            switch (type) {
                default: {
                    return MaterialColor.field_151661_c;
                }
                case SKY: {
                    return MaterialColor.field_241543_af_;
                }
                case ENDER: {
                    return MaterialColor.field_193564_P;
                }
                case ICHOR: 
            }
            return MaterialColor.field_193562_N;
        };
        return BLOCKS.registerEnum(SlimeType.TRUE_SLIME, "slime_dirt", type -> new SlimeDirtBlock(TinkerWorld.builder(Material.field_151578_c, (MaterialColor)color.apply((SlimeType)((Object)((Object)type))), ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.55f)), TOOLTIP_BLOCK_ITEM);
    });
    public static final EnumObject<SlimeType, Block> allDirt = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.BLOOD, (Supplier)Blocks.field_150346_d.delegate).putAll(slimeDirt).build();
    public static final EnumObject<SlimeType, Block> vanillaSlimeGrass;
    public static final EnumObject<SlimeType, Block> earthSlimeGrass;
    public static final EnumObject<SlimeType, Block> skySlimeGrass;
    public static final EnumObject<SlimeType, Block> enderSlimeGrass;
    public static final EnumObject<SlimeType, Block> ichorSlimeGrass;
    public static final Map<SlimeType, EnumObject<SlimeType, Block>> slimeGrass;
    public static final EnumObject<SlimeType, SlimeGrassSeedItem> slimeGrassSeeds;
    public static final WoodBlockObject greenheart;
    public static final WoodBlockObject skyroot;
    public static final WoodBlockObject bloodshroom;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeFern;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeTallGrass;
    public static final EnumObject<SlimeType, Block> slimeSapling;
    public static final EnumObject<SlimeType, Block> slimeLeaves;
    public static final ItemObject<SlimeVineBlock> skySlimeVine;
    public static final ItemObject<SlimeVineBlock> enderSlimeVine;
    public static final EnumObject<TinkerHeadType, SkullBlock> heads;
    public static final EnumObject<TinkerHeadType, WallSkullBlock> wallHeads;
    public static final EnumObject<TinkerHeadType, WallOrFloorItem> headItems;
    public static final RegistryObject<EntityType<EarthSlimeEntity>> earthSlimeEntity;
    public static final RegistryObject<EntityType<SkySlimeEntity>> skySlimeEntity;
    public static final RegistryObject<EntityType<EnderSlimeEntity>> enderSlimeEntity;
    public static final RegistryObject<EntityType<TerracubeEntity>> terracubeEntity;
    public static final RegistryObject<BasicParticleType> skySlimeParticle;
    public static final RegistryObject<BasicParticleType> enderSlimeParticle;
    public static final RegistryObject<BasicParticleType> terracubeParticle;
    public static ConfiguredFeature<?, ?> COPPER_ORE_FEATURE;
    public static ConfiguredFeature<?, ?> COBALT_ORE_FEATURE_SMALL;
    public static ConfiguredFeature<?, ?> COBALT_ORE_FEATURE_LARGE;

    @SubscribeEvent
    void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)earthSlimeEntity.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)skySlimeEntity.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)enderSlimeEntity.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)terracubeEntity.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
    }

    private static void setWoodFireInfo(FireBlock fireBlock, WoodBlockObject wood) {
        fireBlock.func_180686_a((Block)wood.get(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getSlab(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getStairs(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getFence(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getFenceGate(), 5, 20);
        fireBlock.func_180686_a(wood.getLog(), 5, 5);
        fireBlock.func_180686_a(wood.getStrippedLog(), 5, 5);
        fireBlock.func_180686_a(wood.getWood(), 5, 5);
        fireBlock.func_180686_a(wood.getStrippedWood(), 5, 5);
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)earthSlimeEntity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(SlimeType.EARTH));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)skySlimeEntity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(SlimeType.SKY));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)enderSlimeEntity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(SlimeType.ENDER));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)terracubeEntity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, TerracubeEntity::canSpawnHere);
        event.enqueueWork(() -> {
            slimeLeaves.forEach((type, block) -> ComposterBlock.func_220290_a((float)(type.isNether() ? 0.85f : 0.35f), (IItemProvider)block));
            slimeSapling.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            slimeTallGrass.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            slimeFern.forEach(block -> ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)block));
            slimeGrassSeeds.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            ComposterBlock.func_220290_a((float)0.5f, skySlimeVine);
            ComposterBlock.func_220290_a((float)0.5f, enderSlimeVine);
            OptionalDispenseBehavior dispenseArmor = new OptionalDispenseBehavior(){

                protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    this.func_239796_a_(ArmorItem.func_226626_a_((IBlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            heads.forEach(arg_0 -> TinkerWorld.lambda$null$58((IDispenseItemBehavior)dispenseArmor, arg_0));
            heads.forEach(head -> FireworkStarRecipe.field_196215_d.put(head.func_199767_j(), FireworkRocketItem.Shape.CREEPER));
            event.enqueueWork(() -> {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.addAll((Iterable)TileEntityType.field_200985_p.field_223046_I);
                heads.forEach(head -> builder.add(head));
                wallHeads.forEach(head -> builder.add(head));
                TileEntityType.field_200985_p.field_223046_I = builder.build();
            });
        });
        event.enqueueWork(() -> {
            FireBlock fireblock = (FireBlock)Blocks.field_150480_ab;
            TinkerWorld.setWoodFireInfo(fireblock, greenheart);
            TinkerWorld.setWoodFireInfo(fireblock, skyroot);
            BiConsumer<SlimeType, Block> plantFireInfo = (type, block) -> {
                if (type != SlimeType.BLOOD && type != SlimeType.ICHOR) {
                    fireblock.func_180686_a(block, 30, 60);
                }
            };
            slimeLeaves.forEach(plantFireInfo);
            slimeTallGrass.forEach(plantFireInfo);
            slimeFern.forEach(plantFireInfo);
            fireblock.func_180686_a((Block)skySlimeVine.get(), 15, 100);
            fireblock.func_180686_a((Block)enderSlimeVine.get(), 15, 100);
        });
        event.enqueueWork(() -> {
            COPPER_ORE_FEATURE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.resource("copper_ore"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)copperOre.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(40, 0, 60))).func_242728_a()).func_242731_b(((Integer)Config.COMMON.veinCountCopper.get()).intValue()));
            COBALT_ORE_FEATURE_SMALL = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.resource("cobalt_ore_small"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)cobaltOre.get()).func_176223_P(), 4)).func_227228_a_(Features.Placements.field_243998_i).func_242728_a()).func_242731_b((Integer)Config.COMMON.veinCountCobalt.get() / 2));
            COBALT_ORE_FEATURE_LARGE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.resource("cobalt_ore_large"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)cobaltOre.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(32, 16))).func_242728_a()).func_242731_b((Integer)Config.COMMON.veinCountCobalt.get() / 2));
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new WorldRecipeProvider(datagenerator));
        }
    }

    private static /* synthetic */ void lambda$null$58(IDispenseItemBehavior dispenseArmor, SkullBlock head) {
        DispenserBlock.func_199774_a((IItemProvider)head, (IDispenseItemBehavior)dispenseArmor);
    }

    static {
        slimeGrass = new EnumMap<SlimeType, EnumObject<SlimeType, Block>>(SlimeType.class);
        Function<SlimeType, AbstractBlock.Properties> slimeGrassProps = type -> TinkerWorld.builder(Material.field_151577_b, type.getMapColor(), ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.65f).func_200944_c();
        Function<SlimeType, Block> slimeGrassRegister = type -> type.isNether() ? new SlimeNyliumBlock((AbstractBlock.Properties)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)) : new SlimeGrassBlock((AbstractBlock.Properties)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type));
        vanillaSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "vanilla_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        earthSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "earth_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        skySlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "sky_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        enderSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ender_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        ichorSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ichor_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        slimeGrass.put(SlimeType.BLOOD, vanillaSlimeGrass);
        slimeGrass.put(SlimeType.EARTH, earthSlimeGrass);
        slimeGrass.put(SlimeType.SKY, skySlimeGrass);
        slimeGrass.put(SlimeType.ENDER, enderSlimeGrass);
        slimeGrass.put(SlimeType.ICHOR, ichorSlimeGrass);
        slimeGrassSeeds = ITEMS.registerEnum(SlimeType.values(), "slime_grass_seeds", type -> new SlimeGrassSeedItem(WORLD_PROPS, (SlimeType)((Object)type)));
        greenheart = BLOCKS.registerWood("greenheart", SLIME_WOOD, MaterialColor.field_151672_u, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_151575_d, MaterialColor.field_151651_C, SoundType.field_185848_a, TAB_WORLD);
        skyroot = BLOCKS.registerWood("skyroot", SLIME_WOOD, MaterialColor.field_151679_y, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_151575_d, MaterialColor.field_193570_V, SoundType.field_185848_a, TAB_WORLD);
        bloodshroom = BLOCKS.registerWood("bloodshroom", Material.field_151571_B, MaterialColor.field_151645_D, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_237214_y_, MaterialColor.field_151676_q, SoundType.field_235602_z_, TAB_WORLD);
        Function<SlimeType, AbstractBlock.Properties> props = type -> {
            AbstractBlock.Properties properties = type.isNether() ? TinkerWorld.builder(Material.field_242934_h, type.getMapColor(), NO_TOOL, SoundType.field_235581_C_) : TinkerWorld.builder(Material.field_151582_l, type.getMapColor(), NO_TOOL, SoundType.field_185850_c);
            return properties.func_200946_b().func_200942_a();
        };
        slimeFern = BLOCKS.registerEnum(SlimeType.values(), "slime_fern", type -> new SlimeTallGrassBlock((AbstractBlock.Properties)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        slimeTallGrass = BLOCKS.registerEnum(SlimeType.values(), "slime_tall_grass", type -> new SlimeTallGrassBlock((AbstractBlock.Properties)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        slimeSapling = Util.make(() -> {
            Function<SlimeType, AbstractBlock.Properties> props = type -> TinkerWorld.builder(Material.field_151585_k, type.getMapColor(), NO_TOOL, type.isNether() ? SoundType.field_235580_B_ : SoundType.field_185850_c).func_200946_b().func_200942_a();
            return new EnumObject.Builder(SlimeType.class).putAll(BLOCKS.registerEnum(SlimeType.OVERWORLD, "slime_sapling", type -> new SlimeSaplingBlock(new SlimeTree((SlimeType)((Object)((Object)type))), (SlimeType)((Object)((Object)type)), ((AbstractBlock.Properties)props.apply((SlimeType)((Object)((Object)type)))).func_200944_c()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime_sapling", () -> new SlimeFungusBlock((AbstractBlock.Properties)props.apply(SlimeType.BLOOD), () -> TinkerStructures.BLOOD_SLIME_FUNGUS), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime_sapling", () -> new SlimeFungusBlock((AbstractBlock.Properties)props.apply(SlimeType.ICHOR), () -> TinkerStructures.ICHOR_SLIME_FUNGUS), HIDDEN_BLOCK_ITEM)).build();
        });
        slimeLeaves = BLOCKS.registerEnum(SlimeType.values(), "slime_leaves", type -> {
            if (type.isNether()) {
                return new SlimeWartBlock(TinkerWorld.builder(Material.field_151577_b, type.getMapColor(), NO_TOOL, SoundType.field_235588_J_).func_200943_b(1.0f).func_235827_a_((s, w, p, e) -> false), (SlimeType)((Object)type));
            }
            return new SlimeLeavesBlock(TinkerWorld.builder(Material.field_151584_j, type.getMapColor(), NO_TOOL, SoundType.field_185850_c).func_200943_b(0.3f).func_200944_c().func_226896_b_().func_235827_a_((s, w, p, e) -> false), (SlimeType)((Object)type));
        }, DEFAULT_BLOCK_ITEM);
        props = type -> TinkerWorld.builder(Material.field_151582_l, type.getMapColor(), NO_TOOL, SoundType.field_185850_c).func_200943_b(0.3f).func_200942_a().func_200944_c();
        skySlimeVine = BLOCKS.register("sky_slime_vine", () -> new SlimeVineBlock((AbstractBlock.Properties)props.apply(SlimeType.SKY), SlimeType.SKY), DEFAULT_BLOCK_ITEM);
        enderSlimeVine = BLOCKS.register("ender_slime_vine", () -> new SlimeVineBlock((AbstractBlock.Properties)props.apply(SlimeType.ENDER), SlimeType.ENDER), DEFAULT_BLOCK_ITEM);
        heads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "head", type -> new SkullBlock((SkullBlock.ISkullType)type, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(1.0f)));
        wallHeads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "wall_head", type -> new WallSkullBlock((SkullBlock.ISkullType)type, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(1.0f).lootFrom(() -> (SkullBlock)heads.get((Enum)type))));
        headItems = ITEMS.registerEnum(TinkerHeadType.values(), "head", type -> new WallOrFloorItem((Block)heads.get((Enum)type), (Block)wallHeads.get((Enum)type), HEAD_PROPS));
        earthSlimeEntity = ENTITIES.register("earth_slime", () -> EntityType.Builder.func_220322_a(EarthSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).func_220321_a(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (EarthSlimeEntity)((EntityType)earthSlimeEntity.get()).func_200721_a(world)));
        skySlimeEntity = ENTITIES.registerWithEgg("sky_slime", () -> EntityType.Builder.func_220322_a(SkySlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).func_220321_a(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (SkySlimeEntity)((EntityType)skySlimeEntity.get()).func_200721_a(world)), 4714485, 11337716);
        enderSlimeEntity = ENTITIES.registerWithEgg("ender_slime", () -> EntityType.Builder.func_220322_a(EnderSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).func_220321_a(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (EnderSlimeEntity)((EntityType)enderSlimeEntity.get()).func_200721_a(world)), 6488240, 13860095);
        terracubeEntity = ENTITIES.registerWithEgg("terracube", () -> EntityType.Builder.func_220322_a(TerracubeEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(8).func_220321_a(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (TerracubeEntity)((EntityType)terracubeEntity.get()).func_200721_a(world)), 11516374, 10594225);
        skySlimeParticle = PARTICLE_TYPES.register("sky_slime", () -> new BasicParticleType(false));
        enderSlimeParticle = PARTICLE_TYPES.register("ender_slime", () -> new BasicParticleType(false));
        terracubeParticle = PARTICLE_TYPES.register("terracube", () -> new BasicParticleType(false));
    }
}

