/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.client.particle.SlimeParticle;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.client.HeadWithOverlayModel;
import slimeknights.tconstruct.world.client.SlimeColorReloadListener;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import slimeknights.tconstruct.world.client.TerracubeRenderer;
import slimeknights.tconstruct.world.client.TinkerSlimeRenderer;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldClientEvents
extends ClientEventBase {
    public static void addResourceListener(IReloadableResourceManager manager) {
        for (SlimeType type : SlimeType.values()) {
            manager.func_219534_a((IFutureReloadListener)new SlimeColorReloadListener(type));
        }
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)TinkerWorld.skySlimeParticle.get(), (IParticleFactory)new SlimeParticle.Factory(SlimeType.SKY));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)TinkerWorld.enderSlimeParticle.get(), (IParticleFactory)new SlimeParticle.Factory(SlimeType.ENDER));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)TinkerWorld.terracubeParticle.get(), (IParticleFactory)new SlimeParticle.Factory((IItemProvider)Items.field_151119_aD));
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerWorld.earthSlimeEntity.get()), SlimeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerWorld.skySlimeEntity.get()), (IRenderFactory)TinkerSlimeRenderer.SKY_SLIME_FACTORY);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerWorld.enderSlimeEntity.get()), (IRenderFactory)TinkerSlimeRenderer.ENDER_SLIME_FACTORY);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerWorld.terracubeEntity.get()), (IRenderFactory)TerracubeRenderer.TERRACUBE_RENDERER);
        RenderType cutout = RenderType.func_228643_e_();
        RenderType cutoutMipped = RenderType.func_228641_d_();
        for (SlimeType type : SlimeType.values()) {
            if (type != SlimeType.BLOOD) {
                RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.slimeLeaves.get((Enum)type)), (RenderType)cutoutMipped);
            }
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.vanillaSlimeGrass.get((Enum)type)), (RenderType)cutoutMipped);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.earthSlimeGrass.get((Enum)type)), (RenderType)cutoutMipped);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.skySlimeGrass.get((Enum)type)), (RenderType)cutoutMipped);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.enderSlimeGrass.get((Enum)type)), (RenderType)cutoutMipped);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.ichorSlimeGrass.get((Enum)type)), (RenderType)cutoutMipped);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.slimeFern.get((Enum)type)), (RenderType)cutout);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.slimeTallGrass.get((Enum)type)), (RenderType)cutout);
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.slimeSapling.get((Enum)type)), (RenderType)cutout);
        }
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.enderSlimeVine.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.skySlimeVine.get()), (RenderType)cutout);
        RenderType translucent = RenderType.func_228645_f_();
        for (SlimeType type : SlimeType.TINKER) {
            RenderTypeLookup.setRenderLayer((Block)((Block)TinkerWorld.slime.get((Enum)type)), (RenderType)translucent);
        }
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.greenheart.getDoor(), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.greenheart.getTrapdoor(), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.skyroot.getDoor(), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.skyroot.getTrapdoor(), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.bloodshroom.getDoor(), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)TinkerWorld.bloodshroom.getTrapdoor(), (RenderType)cutout);
        GenericHeadModel normalHead = new GenericHeadModel(0, 0, 64, 32);
        HeadWithOverlayModel tinkersOverlayHead = new HeadWithOverlayModel(0, 0, 0, 16, 32, 32);
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.BLAZE, normalHead);
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.ENDERMAN, new GenericHeadModel(0, 0, 32, 16));
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.STRAY, tinkersOverlayHead);
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.BLAZE, new ResourceLocation("textures/entity/blaze.png"));
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.ENDERMAN, TConstruct.getResource("textures/entity/skull/enderman.png"));
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.STRAY, TConstruct.getResource("textures/entity/skull/stray.png"));
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.HUSK, new GenericHeadModel(0, 0, 64, 64));
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.DROWNED, tinkersOverlayHead);
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.HUSK, new ResourceLocation("textures/entity/zombie/husk.png"));
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.DROWNED, TConstruct.getResource("textures/entity/skull/drowned.png"));
        GenericHeadModel spiderHead = new GenericHeadModel(32, 4, 64, 32);
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.SPIDER, spiderHead);
        SkullTileEntityRenderer.field_199358_e.put(TinkerHeadType.CAVE_SPIDER, spiderHead);
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.SPIDER, new ResourceLocation("textures/entity/spider/spider.png"));
        SkullTileEntityRenderer.field_199357_d.put(TinkerHeadType.CAVE_SPIDER, new ResourceLocation("textures/entity/spider/cave_spider.png"));
    }

    @SubscribeEvent
    static void registerBlockColorHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        for (SlimeType type : SlimeType.values()) {
            blockColors.func_186722_a((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), new Block[]{(Block)TinkerWorld.vanillaSlimeGrass.get((Enum)type), (Block)TinkerWorld.earthSlimeGrass.get((Enum)type), (Block)TinkerWorld.skySlimeGrass.get((Enum)type), (Block)TinkerWorld.enderSlimeGrass.get((Enum)type), (Block)TinkerWorld.ichorSlimeGrass.get((Enum)type)});
            blockColors.func_186722_a((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.slimeLeaves.get((Enum)type)});
            blockColors.func_186722_a((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), new Block[]{(Block)TinkerWorld.slimeFern.get((Enum)type), (Block)TinkerWorld.slimeTallGrass.get((Enum)type)});
        }
        blockColors.func_186722_a((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, SlimeType.SKY, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.skySlimeVine.get()});
        blockColors.func_186722_a((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, SlimeType.ENDER, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.enderSlimeVine.get()});
    }

    @SubscribeEvent
    static void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.vanillaSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.earthSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.skySlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.enderSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.ichorSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeLeaves);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeFern);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeTallGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.skySlimeVine);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.enderSlimeVine);
    }

    private static int getSlimeColorByPos(@Nullable BlockPos pos, SlimeType type, @Nullable BlockPos add) {
        if (pos == null) {
            return SlimeColorizer.getColorStatic(type);
        }
        if (add != null) {
            pos = pos.func_177971_a((Vector3i)add);
        }
        return SlimeColorizer.getColorForPos(pos, type);
    }
}

