/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SkullBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.json.SetFluidLootFunction;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    private static boolean foundField = false;
    private static Field lootEntries = null;

    @SubscribeEvent
    static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.NETHER) {
            if (((Boolean)Config.COMMON.generateBloodIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.BLOOD_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateCobalt.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_SMALL);
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_LARGE);
            }
        } else if (category != Biome.Category.THEEND) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.earthSlimeEntity.get(), 100, 2, 4));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.skySlimeEntity.get(), 100, 2, 4));
            if (((Boolean)Config.COMMON.generateSkySlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.SKY_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateClayIslands.get()).booleanValue() && category != Biome.Category.TAIGA && category != Biome.Category.JUNGLE && category != Biome.Category.FOREST && category != Biome.Category.OCEAN && category != Biome.Category.SWAMP) {
                generation.func_242516_a(TinkerStructures.CLAY_ISLAND);
            }
            if (category == Biome.Category.OCEAN && ((Boolean)Config.COMMON.generateEarthSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.EARTH_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateCopper.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TinkerWorld.COPPER_ORE_FEATURE);
            }
        } else if (!WorldEvents.doesNameMatchBiomes(event.getName(), Biomes.field_76779_k, Biomes.field_185440_P)) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.enderSlimeEntity.get(), 10, 2, 4));
            if (((Boolean)Config.COMMON.generateEndSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.END_SLIME_ISLAND);
            }
        }
    }

    private static boolean doesNameMatchBiomes(@Nullable ResourceLocation name, RegistryKey<?> ... biomes) {
        for (RegistryKey<?> biome : biomes) {
            if (!biome.func_240901_a_().equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    private static void addEntry(LootPool pool, LootEntry entry) {
        if (!foundField) {
            try {
                lootEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
                lootEntries.setAccessible(true);
                foundField = true;
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
                TConstruct.LOG.error("Failed to find field", (Throwable)ex);
                foundField = true;
                return;
            }
        }
        try {
            Object field = lootEntries.get(pool);
            if (field instanceof List) {
                List entries = (List)field;
                entries.add(entry);
            }
        }
        catch (ClassCastException | IllegalAccessException ex) {
            TConstruct.LOG.error("Failed to access field", (Throwable)ex);
            lootEntries = null;
        }
    }

    private static void injectInto(LootTableLoadEvent event, String tableName, String poolName, Supplier<LootEntry> entry) {
        LootPool pool;
        ResourceLocation name = event.getName();
        if ("minecraft".equals(name.func_110624_b()) && tableName.equals(name.func_110623_a()) && (pool = event.getTable().getPool(poolName)) != null) {
            WorldEvents.addEntry(pool, entry.get());
        }
    }

    @SubscribeEvent
    static void onLootTableLoad(LootTableLoadEvent event) {
        BiFunction<SlimeType, Integer, LootEntry> makeSeed = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeGrassSeeds.get((Enum)type))).func_216086_a(weight.intValue()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(2.0f, 4.0f))).func_216081_b();
        BiFunction<SlimeType, Integer, LootEntry> makeSapling = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeSapling.get((Enum)type))).func_216086_a(weight.intValue()).func_216081_b();
        WorldEvents.injectInto(event, "chests/simple_dungeon", "pool1", () -> (LootEntry)makeSeed.apply(SlimeType.EARTH, 3));
        WorldEvents.injectInto(event, "chests/simple_dungeon", "pool1", () -> (LootEntry)makeSeed.apply(SlimeType.SKY, 7));
        WorldEvents.injectInto(event, "chests/simple_dungeon", "main", () -> (LootEntry)makeSapling.apply(SlimeType.EARTH, 3));
        WorldEvents.injectInto(event, "chests/simple_dungeon", "main", () -> (LootEntry)makeSapling.apply(SlimeType.SKY, 7));
        WorldEvents.injectInto(event, "chests/nether_bridge", "main", () -> (LootEntry)makeSeed.apply(SlimeType.BLOOD, 5));
        WorldEvents.injectInto(event, "chests/bastion_bridge", "pool2", () -> (LootEntry)makeSapling.apply(SlimeType.BLOOD, 1));
        WorldEvents.injectInto(event, "chests/end_city_treasure", "main", () -> (LootEntry)makeSeed.apply(SlimeType.ENDER, 5));
        WorldEvents.injectInto(event, "chests/end_city_treasure", "main", () -> (LootEntry)makeSapling.apply(SlimeType.ENDER, 3));
        WorldEvents.injectInto(event, "gameplay/piglin_bartering", "main", () -> ItemLootEntry.func_216168_a(TinkerSmeltery.scorchedLantern).func_216086_a(20).func_212841_b_(SetFluidLootFunction.builder(new FluidStack((Fluid)TinkerFluids.blazingBlood.get(), 100))).func_216081_b());
    }

    @SubscribeEvent
    public void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        Item helmet = entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b();
        Item item = helmet.getItem();
        if (item != Items.field_190931_a && TinkerWorld.headItems.contains((IForgeRegistryEntry)item)) {
            if (lookingEntity.func_200600_R() == ((TinkerHeadType)((SkullBlock)((BlockItem)item).func_179223_d()).field_196293_a).getType()) {
                event.modifyVisibility(0.5);
            }
            EntityType entityType = lookingEntity.func_200600_R();
        }
    }

    @SubscribeEvent
    public void creeperKill(LivingDropsEvent event) {
        LivingEntity dying;
        TinkerHeadType headType;
        CreeperEntity creeper;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.func_76346_g()) instanceof CreeperEntity && (creeper = (CreeperEntity)entity).func_70650_aV() && (headType = TinkerHeadType.fromEntityType((dying = event.getEntityLiving()).func_200600_R())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.func_175493_co();
            event.getDrops().add(dying.func_199703_a((IItemProvider)TinkerWorld.heads.get((Enum)headType)));
        }
    }
}

