/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class EarthSlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public EarthSlimeIslandVariant(int index, SlimeType dirtType) {
        super(index, dirtType, SlimeType.EARTH);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/earth/" + this.dirtType.func_176610_l() + "_" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return SlimeType.EARTH;
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.earthSlime.getBlock()).func_176223_P();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.EARTH_SLIME_ISLAND_TREE;
    }

    private static boolean isWater(ISeedReader world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    @Override
    public boolean isPositionValid(ISeedReader world, BlockPos pos, ChunkGenerator generator) {
        BlockPos up = pos.func_177984_a();
        if (EarthSlimeIslandVariant.isWater(world, up)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (EarthSlimeIslandVariant.isWater(world, up.func_177972_a(direction))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

