/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.lists.ItemList;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Roof_Normal
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = Roof_Normal.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = Roof_Normal.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block modelBlock;
    private final BlockState modelState;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> Roof_Normal.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public Roof_Normal(BlockState state, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = state.func_177230_c();
        this.modelState = state;
        this.stateSupplier = () -> state;
    }

    public Roof_Normal(Supplier<BlockState> state, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = Blocks.field_150350_a;
        this.modelState = Blocks.field_150350_a.func_176223_P();
        this.stateSupplier = state;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b(SHAPE) != null ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.modelState.func_196942_a(worldIn, pos, player);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        this.modelBlock.func_176206_d(worldIn, pos, state);
    }

    public float func_149638_a() {
        return this.modelBlock.func_149638_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item != ItemList.roofing_hammer) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_235896_a_(SHAPE);
        worldIn.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.modelBlock.func_225542_b_(state, worldIn, pos, random);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_225534_a_(state, worldIn, pos, rand);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != state.func_177230_c()) {
            this.modelState.func_215697_a(worldIn, pos, Blocks.field_150350_a, pos, false);
            this.modelBlock.func_220082_b(this.modelState, worldIn, pos, oldState, false);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.modelState.func_196947_b(worldIn, pos, newState, isMoving);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.modelBlock.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.modelBlock.func_180652_a(worldIn, pos, explosionIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)Roof_Normal.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), blockpos));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)Roof_Normal.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (Roof_Normal.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && Roof_Normal.isDifferentStairs(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (Roof_Normal.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && Roof_Normal.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !Roof_Normal.isBlockStairs(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof Roof_Normal;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().func_177230_c();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }
}

