/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class DataLines {
    @Nullable
    public static TargetDataLine getMicrophone(AudioFormat format) {
        TargetDataLine mic;
        String micName = (String)Main.CLIENT_CONFIG.microphone.get();
        if (!micName.isEmpty() && (mic = DataLines.getMicrophoneByName(format, micName)) != null) {
            return mic;
        }
        return DataLines.getDefaultMicrophone(format);
    }

    @Nullable
    public static SourceDataLine getSpeaker(AudioFormat format) {
        SourceDataLine speaker;
        String speakerName = (String)Main.CLIENT_CONFIG.speaker.get();
        if (!speakerName.isEmpty() && (speaker = DataLines.getSpeakerByName(format, speakerName)) != null) {
            return speaker;
        }
        return DataLines.getDefaultSpeaker(format);
    }

    @Nullable
    public static TargetDataLine getDefaultMicrophone(AudioFormat format) {
        return DataLines.getDefaultDevice(TargetDataLine.class, format);
    }

    @Nullable
    public static SourceDataLine getDefaultSpeaker(AudioFormat format) {
        return DataLines.getDefaultDevice(SourceDataLine.class, format);
    }

    @Nullable
    public static <T> T getDefaultDevice(Class<T> lineClass, AudioFormat format) {
        DataLine.Info info = new DataLine.Info(lineClass, format);
        try {
            return lineClass.cast(AudioSystem.getLine(info));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static TargetDataLine getMicrophoneByName(AudioFormat format, String name) {
        return DataLines.getDeviceByName(TargetDataLine.class, format, name);
    }

    @Nullable
    public static SourceDataLine getSpeakerByName(AudioFormat format, String name) {
        return DataLines.getDeviceByName(SourceDataLine.class, format, name);
    }

    @Nullable
    public static <T> T getDeviceByName(Class<T> lineClass, AudioFormat format, String name) {
        Mixer.Info[] mixers;
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(lineClass, format)) || !mixerInfo.getName().equals(name)) continue;
            try {
                return lineClass.cast(mixer.getLine(lineInfo));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<String> getMicrophoneNames(AudioFormat format) {
        return DataLines.getDeviceNames(TargetDataLine.class, format);
    }

    public static List<String> getSpeakerNames(AudioFormat format) {
        return DataLines.getDeviceNames(SourceDataLine.class, format);
    }

    public static List<String> getDeviceNames(Class<?> lineClass, AudioFormat format) {
        Mixer.Info[] mixers;
        ArrayList<String> names = new ArrayList<String>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(lineClass, format))) continue;
            names.add(mixerInfo.getName());
        }
        return names;
    }
}

