/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.tiviacz.travelersbackpack.client.gui.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final FluidTank tank;

    public TankScreen(FluidTank tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<ITextComponent> getTankTooltip() {
        String fluidAmount;
        FluidStack fluidStack = this.tank.getFluid();
        ArrayList<ITextComponent> tankTips = new ArrayList<ITextComponent>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getDisplayName().getString() : I18n.func_135052_a((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        String string = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + this.tank.getCapacity() : I18n.func_135052_a((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.getTag() != null && fluidStack.getTag().func_74764_b("Potion")) {
            fluidName = I18n.func_135052_a((String)PotionUtils.func_185191_c((ItemStack)FluidUtils.getItemStackFromFluidStack(fluidStack)).func_185174_b("potion.effect."), (Object[])new Object[0]);
        }
        tankTips.add((ITextComponent)new StringTextComponent(fluidName));
        tankTips.add((ITextComponent)new StringTextComponent(fluidAmount));
        return tankTips;
    }

    public void setPotionDescription(FluidStack fluidStack, List<String> lores) {
        List list = PotionUtils.func_185189_a((ItemStack)FluidUtils.getItemStackFromFluidStack(fluidStack));
        if (list.isEmpty()) {
            String s = I18n.func_135052_a((String)"effect.none", (Object[])new Object[0]).trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (EffectInstance effectInstance : list) {
                String s1 = I18n.func_135052_a((String)effectInstance.func_76453_d(), (Object[])new Object[0]).trim();
                if (effectInstance.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + effectInstance.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (effectInstance.func_76459_b() > 20) {
                    s1 = s1 + " (" + effectInstance.func_76459_b() + ")";
                }
                if (!effectInstance.func_188419_a().func_188408_i()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
    }

    public void drawScreenFluidBar(MatrixStack matrixStackIn) {
        RenderUtils.renderScreenTank(matrixStackIn, this.tank, this.startX, this.startY, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackScreen screen, int mouseX, int mouseY) {
        return this.startX <= (mouseX -= screen.getGuiLeft()) && mouseX <= this.startX + this.width && this.startY <= (mouseY -= screen.getGuiTop()) && mouseY <= this.startY + this.height;
    }
}

