/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BackpackDyeRecipe
extends SpecialRecipe {
    public BackpackDyeRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack1 = inv.func_70301_a(i);
            if (itemstack1.func_190926_b()) continue;
            if (itemstack1.func_77973_b() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
                if (!itemstack.func_190926_b()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (!(itemstack1.func_77973_b() instanceof DyeItem)) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.func_190926_b() && !list.isEmpty();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ArrayList list = Lists.newArrayList();
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingredient = inv.func_70301_a(i);
            if (ingredient.func_190926_b()) continue;
            if (ingredient.func_77973_b() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
                stack = inv.func_70301_a(i).func_77946_l();
                continue;
            }
            if (!(ingredient.func_77973_b() instanceof DyeItem)) {
                return ItemStack.field_190927_a;
            }
            list.add((DyeItem)ingredient.func_77973_b());
        }
        return !stack.func_190926_b() && !list.isEmpty() ? BackpackDyeRecipe.dyeItem(stack, list) : ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModCrafting.BACKPACK_DYE;
    }

    public static boolean hasColor(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74764_b("Color");
        }
        return false;
    }

    public static int getColor(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("Color");
    }

    public static void setColor(ItemStack stack, int color) {
        if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a("Color", color);
        } else {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("Color", color);
            stack.func_77982_d(compoundNBT);
        }
    }

    public static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyeItem) {
        if (stack.func_77973_b() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            int lvt_13_1_;
            float b;
            int[] ints = new int[3];
            int lvt_4_1_ = 0;
            int lvt_5_1_ = 0;
            if (BackpackDyeRecipe.hasColor(stack)) {
                int baseColor = BackpackDyeRecipe.getColor(stack);
                float r = (float)(baseColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(baseColor >> 8 & 0xFF) / 255.0f;
                b = (float)(baseColor & 0xFF) / 255.0f;
                lvt_4_1_ = (int)((float)lvt_4_1_ + Math.max(r, Math.max(g, b)) * 255.0f);
                ints[0] = (int)((float)ints[0] + r * 255.0f);
                ints[1] = (int)((float)ints[1] + g * 255.0f);
                ints[2] = (int)((float)ints[2] + b * 255.0f);
                ++lvt_5_1_;
            }
            for (DyeItem lvt_9_2_ : dyeItem) {
                float[] lvt_10_2_ = lvt_9_2_.func_195962_g().func_193349_f();
                int lvt_11_2_ = (int)(lvt_10_2_[0] * 255.0f);
                int lvt_12_1_ = (int)(lvt_10_2_[1] * 255.0f);
                lvt_13_1_ = (int)(lvt_10_2_[2] * 255.0f);
                lvt_4_1_ += Math.max(lvt_11_2_, Math.max(lvt_12_1_, lvt_13_1_));
                ints[0] = ints[0] + lvt_11_2_;
                ints[1] = ints[1] + lvt_12_1_;
                ints[2] = ints[2] + lvt_13_1_;
                ++lvt_5_1_;
            }
            int lvt_8_2_ = ints[0] / lvt_5_1_;
            int lvt_9_3_ = ints[1] / lvt_5_1_;
            int lvt_10_3_ = ints[2] / lvt_5_1_;
            b = (float)lvt_4_1_ / (float)lvt_5_1_;
            float lvt_12_2_ = Math.max(lvt_8_2_, Math.max(lvt_9_3_, lvt_10_3_));
            lvt_8_2_ = (int)((float)lvt_8_2_ * b / lvt_12_2_);
            lvt_9_3_ = (int)((float)lvt_9_3_ * b / lvt_12_2_);
            lvt_10_3_ = (int)((float)lvt_10_3_ * b / lvt_12_2_);
            lvt_13_1_ = (lvt_8_2_ << 8) + lvt_9_3_;
            lvt_13_1_ = (lvt_13_1_ << 8) + lvt_10_3_;
            BackpackDyeRecipe.setColor(stack, lvt_13_1_);
        }
        return stack;
    }
}

