/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessBackpackRecipe
extends ShapelessRecipe {
    public ShapelessBackpackRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack output = super.func_77572_b(inv);
        if (!output.func_190926_b()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredient = inv.func_70301_a(i);
                if (ingredient.func_190926_b() || !(ingredient.func_77973_b() instanceof TravelersBackpackItem)) continue;
                CompoundNBT compound = ingredient.func_77978_p();
                output.func_77982_d(compound);
                break;
            }
        }
        return output;
    }

    private ItemStack damageShears(ItemStack stack) {
        PlayerEntity craftingPlayer = ForgeHooks.getCraftingPlayer();
        if (stack.func_96631_a(1, craftingPlayer == null ? new Random() : craftingPlayer.field_70170_p.field_73012_v, craftingPlayer instanceof ServerPlayerEntity ? (ServerPlayerEntity)craftingPlayer : null)) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)craftingPlayer, (ItemStack)stack, null);
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventoryCrafting) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ShearsItem) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.func_77946_l()));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModCrafting.BACKPACK_SHAPELESS;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessBackpackRecipe> {
        public ShapelessBackpackRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapelessBackpackRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ShapelessBackpackRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapelessBackpackRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void write(PacketBuffer buffer, ShapelessBackpackRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

