/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TravelersBackpackConfig {
    public static boolean toolSlotsAcceptSwords;
    public static boolean disableCrafting;
    public static boolean enableBackpackBlockWearable;
    public static boolean enableLoot;
    public static boolean invulnerableBackpack;
    public static int tanksCapacity;
    public static boolean curiosIntegration;
    public static boolean enableBackpackAbilities;
    public static boolean backpackDeathPlace;
    public static boolean backpackForceDeathPlace;
    public static boolean enableEmptyTankButton;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean displayWarning;
    public static boolean enableBackpackCoordsMessage;
    public static boolean enableToolCycling;
    public static boolean disableScrollWheel;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;
    private static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.SERVER, serverSpec);
        context.registerConfig(ModConfig.Type.COMMON, commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == serverSpec) {
            TravelersBackpackConfig.bakeServerConfig();
        }
        if (configEvent.getConfig().getSpec() == commonSpec) {
            TravelersBackpackConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            TravelersBackpackConfig.bakeClientConfig();
        }
    }

    public static void bakeServerConfig() {
        toolSlotsAcceptSwords = (Boolean)TravelersBackpackConfig.SERVER.toolSlotsAcceptSwords.get();
        enableBackpackBlockWearable = (Boolean)TravelersBackpackConfig.SERVER.enableBackpackBlockWearable.get();
        disableCrafting = (Boolean)TravelersBackpackConfig.SERVER.disableCrafting.get();
        enableLoot = (Boolean)TravelersBackpackConfig.SERVER.enableLoot.get();
        invulnerableBackpack = (Boolean)TravelersBackpackConfig.SERVER.invulnerableBackpack.get();
        tanksCapacity = (Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get();
    }

    public static void bakeCommonConfig() {
        curiosIntegration = (Boolean)TravelersBackpackConfig.COMMON.curiosIntegration.get();
        enableBackpackAbilities = (Boolean)TravelersBackpackConfig.COMMON.enableBackpackAbilities.get();
        backpackDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackDeathPlace.get();
        backpackForceDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackForceDeathPlace.get();
        enableEmptyTankButton = (Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get();
        enableSleepingBagSpawnPoint = (Boolean)TravelersBackpackConfig.COMMON.enableSleepingBagSpawnPoint.get();
    }

    public static void bakeClientConfig() {
        displayWarning = (Boolean)TravelersBackpackConfig.CLIENT.displayWarning.get();
        enableBackpackCoordsMessage = (Boolean)TravelersBackpackConfig.CLIENT.enableBackpackCoordsMessage.get();
        enableToolCycling = (Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get();
        disableScrollWheel = (Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get();
        obtainTips = (Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get();
        renderTools = (Boolean)TravelersBackpackConfig.CLIENT.renderTools.get();
        renderBackpackWithElytra = (Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get();
        enableOverlay = (Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get();
        offsetX = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        offsetY = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue displayWarning;
        public final ForgeConfigSpec.BooleanValue enableBackpackCoordsMessage;
        public final ForgeConfigSpec.BooleanValue enableToolCycling;
        public final ForgeConfigSpec.BooleanValue disableScrollWheel;
        public final ForgeConfigSpec.BooleanValue obtainTips;
        public final ForgeConfigSpec.BooleanValue renderTools;
        public final ForgeConfigSpec.BooleanValue renderBackpackWithElytra;
        public final Overlay overlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.displayWarning = builder.comment("Displays warning about item deletion after updating from older version").translation("travelersbackpack.config.client.displayWarning").define("displayWarning", true);
            this.enableBackpackCoordsMessage = builder.comment("Enables auto message with backpack coords after player dies").translation("travelersbackpack.config.client.enableBackpackCoordsMessage").define("enableBackpackCoordsMessage", true);
            this.enableToolCycling = builder.comment("Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn").translation("travelersbackpack.config.client.enableToolCycling").define("enableToolCycling", true);
            this.disableScrollWheel = builder.comment("Allows tool cycling using keybinding only (Default Z)").translation("travelersbackpack.config.client.disableScrollWheel").define("disableScrollWheel", false);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").translation("travelersbackpack.config.client.obtainTips").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").translation("travelersbackpack.config.client.renderTools").define("renderTools", true);
            this.renderBackpackWithElytra = builder.comment("Render backpack if elytra is present").translation("travelersbackpack.config.client.renderBackpackWithElytra").define("renderBackpackWithElytra", true);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ForgeConfigSpec.BooleanValue enableOverlay;
            public final ForgeConfigSpec.IntValue offsetX;
            public final ForgeConfigSpec.IntValue offsetY;

            Overlay(ForgeConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue curiosIntegration;
        public final ForgeConfigSpec.BooleanValue enableBackpackAbilities;
        public final ForgeConfigSpec.BooleanValue backpackDeathPlace;
        public final ForgeConfigSpec.BooleanValue backpackForceDeathPlace;
        public final ForgeConfigSpec.BooleanValue enableEmptyTankButton;
        public final ForgeConfigSpec.BooleanValue enableSleepingBagSpawnPoint;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.curiosIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in curios 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).translation("travelersbackpack.config.server.curiosIntegration").define("curiosIntegration", false);
            this.enableBackpackAbilities = builder.translation("travelersbackpack.config.common.enableBackpackAbilities").define("enableBackpackAbilities", true);
            this.backpackDeathPlace = builder.comment("Places backpack at place where player died").translation("travelersbackpack.config.common.backpackDeathPlace").define("backpackDeathPlace", true);
            this.backpackForceDeathPlace = builder.comment("Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)").translation("travelersbackpack.config.common.backpackForceDeathPlace").define("backpackForceDeathPlace", false);
            this.enableEmptyTankButton = builder.comment("Enables button in backpack gui, which allows to empty tank").translation("travelersbackpack.config.common.enableEmptyTankButton").define("enableEmptyTankButton", true);
            this.enableSleepingBagSpawnPoint = builder.translation("travelersbackpack.config.common.enableSleepingBagSpawnPoint").define("enableSleepingBagSpawnPoint", false);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue toolSlotsAcceptSwords;
        public final ForgeConfigSpec.BooleanValue disableCrafting;
        public final ForgeConfigSpec.BooleanValue enableBackpackBlockWearable;
        public final ForgeConfigSpec.BooleanValue enableLoot;
        public final ForgeConfigSpec.BooleanValue invulnerableBackpack;
        public final ForgeConfigSpec.IntValue tanksCapacity;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server config settings").push("server");
            this.toolSlotsAcceptSwords = builder.translation("travelersbackpack.config.server.toolSlotsAcceptSwords").define("toolSlotsAcceptSwords", true);
            this.disableCrafting = builder.translation("travelersbackpack.config.server.disableCrafting").define("disableCrafting", false);
            this.enableBackpackBlockWearable = builder.comment("Enables wearing backpack directly from ground").translation("travelersbackpack.config.server.enableBackpackBlockWearable").define("enableBackpackBlockWearable", true);
            this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").translation("travelersbackpack.config.server.enableLoot").define("enableLoot", true);
            this.invulnerableBackpack = builder.comment("Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item").translation("travelersbackpack.config.server.invulnerableBackpack").define("invulnerableBackpack", true);
            this.tanksCapacity = builder.translation("travelersbackpack.config.server.tanksCapacity").defineInRange("tanksCapacity", 4000, 250, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

