/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.effects.LavaEffect;
import com.tiviacz.travelersbackpack.fluids.effects.WaterEffect;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class EffectFluidRegistry {
    public static BiMap<String, EffectFluid> EFFECT_REGISTRY = HashBiMap.create();
    public static EffectFluid WATER_EFFECT;
    public static EffectFluid LAVA_EFFECT;
    public static EffectFluid POTION_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new WaterEffect();
        LAVA_EFFECT = new LavaEffect();
    }

    public static int registerFluidEffect(EffectFluid effect) {
        String className = effect.getClass().getName();
        if (!EFFECT_REGISTRY.containsKey((Object)className) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)className, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the class " + className + " as a FluidEffect for " + effect.fluid.getAttributes().getDisplayName(new FluidStack(effect.fluid, 1000)).getString() + " with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static Map<String, EffectFluid> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static String[] getRegisteredFluids() {
        String[] result = new String[EFFECT_REGISTRY.size()];
        int counter = 0;
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            result[counter++] = effect.fluid.getRegistryType().getName();
        }
        return result;
    }

    public static boolean hasFluidEffect(Fluid fluid) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return true;
        }
        return false;
    }

    public static EffectFluid getFluidEffect(Fluid fluid) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return effect;
        }
        return null;
    }

    public static ArrayList<EffectFluid> getEffectsForFluid(Fluid fluid) {
        ArrayList<EffectFluid> effectsForFluid = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EFFECT_REGISTRY.values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean hasFluidEffectAndCanExecute(FluidStack fluid, World world, Entity entity) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid.getFluid() != effect.fluid || !effect.canExecuteEffect(fluid, world, entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean executeFluidEffectsForFluid(FluidStack fluid, Entity entity, World world) {
        boolean executed = false;
        for (EffectFluid effect : EFFECT_REGISTRY.values()) {
            if (effect == null || effect.fluid != fluid.getFluid()) continue;
            effect.affectDrinker(fluid, world, entity);
            executed = true;
        }
        return executed;
    }

    static {
        effectIDCounter = 0;
    }
}

