/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.common.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.SyncBackpackCapabilityClient;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        World world = event.getPlayer().field_70170_p;
        if (event.getNewSpawn() != null) {
            Block block = world.func_180495_p(event.getNewSpawn()).func_177230_c();
            if (!world.field_72995_K && block instanceof SleepingBagBlock && !((Boolean)TravelersBackpackConfig.COMMON.enableSleepingBagSpawnPoint.get()).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerWashBackpack(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (event.getWorld().field_72995_K || event.getPlayer().func_225608_bj_()) {
            return;
        }
        if (stack.func_77973_b() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = event.getWorld().func_180495_p(event.getPos());
            if (BackpackDyeRecipe.hasColor(stack) && blockState.func_177230_c() instanceof CauldronBlock && (Integer)blockState.func_177229_b((Property)CauldronBlock.field_176591_a) > 0) {
                stack.func_77978_p().func_82580_o("Color");
                ((CauldronBlock)blockState.func_177230_c()).func_176590_a(event.getWorld(), event.getPos(), blockState, (Integer)blockState.func_177229_b((Property)CauldronBlock.field_176591_a) - 1);
                event.getWorld().func_184148_a(null, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177956_o(), SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemEntityJoin(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof ItemEntity) || !((Boolean)TravelersBackpackConfig.SERVER.invulnerableBackpack.get()).booleanValue()) {
            return;
        }
        if (((ItemEntity)event.getEntity()).func_92059_d().func_77973_b() instanceof TravelersBackpackItem) {
            ((ItemEntity)event.getEntity()).func_174873_u();
            event.getEntity().func_184224_h(true);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable((PlayerEntity)event.getObject());
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && CapabilityUtils.isWearingBackpack(player = (PlayerEntity)event.getEntity())) {
            if (!player.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                BackpackUtils.onPlayerDeath(player.field_70170_p, player, CapabilityUtils.getWearingBackpack(player));
            }
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        CapabilityUtils.getCapability(event.getOriginal()).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getPlayer()).ifPresent(newTravelersBackpack -> newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable())));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity && !event.getTarget().field_70170_p.field_72995_K) {
            ServerPlayerEntity target = (ServerPlayerEntity)event.getTarget();
            CapabilityUtils.getCapability((PlayerEntity)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SyncBackpackCapabilityClient(CapabilityUtils.getWearingBackpack((PlayerEntity)target).func_77955_b(new CompoundNBT()), target.func_145782_y())));
        }
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !(((ItemEntity)entity).func_92059_d().func_77973_b() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.enableLoot.get()).booleanValue() && event.getName().equals((Object)new ResourceLocation("chests/abandoned_mineshaft"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("travelersbackpack", "chests/bat"))).func_216044_b());
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221160_j) {
            ((List)event.getTrades().get(5)).add(new BackpackVillagerTrade());
        }
    }

    private static class BackpackVillagerTrade
    implements VillagerTrades.ITrade {
        private BackpackVillagerTrade() {
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, random.nextInt(64) + 48), new ItemStack((IItemProvider)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).getItem(), 1), 1, 5, 0.5f);
        }
    }
}

