/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.container.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.container.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TravelersBackpackBaseContainer
extends Container {
    public PlayerInventory playerInventory;
    public ITravelersBackpackInventory inventory;
    public CraftingInventoryImproved craftMatrix;
    public CraftResultInventory craftResult = new CraftResultInventory();
    private final int CRAFTING_GRID_START = 1;
    private final int CRAFTING_GRID_END = 9;
    private final int BACKPACK_INV_START = 10;
    private final int BACKPACK_INV_END = 48;
    private final int TOOL_START = 49;
    private final int TOOL_END = 50;
    private final int BUCKET_LEFT_IN = 51;
    private final int BUCKET_LEFT_OUT = 52;
    private final int BUCKET_RIGHT_IN = 53;
    private final int BUCKET_RIGHT_OUT = 54;
    private final int PLAYER_INV_START = 55;
    private final int PLAYER_HOT_END = 90;

    public TravelersBackpackBaseContainer(ContainerType<?> type, int windowID, PlayerInventory playerInventory, ITravelersBackpackInventory inventory) {
        super(type, windowID);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this);
        int currentItemIndex = playerInventory.field_70461_c;
        this.addCraftResult();
        this.addCraftMatrix();
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInventory, currentItemIndex);
        this.func_75130_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)inventory.getCraftingGridInventory()));
    }

    public void addCraftMatrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 152 + j * 18, 61 + i * 18){

                    public boolean func_75214_a(ItemStack stack) {
                        ResourceLocation blacklistedItems = new ResourceLocation("travelersbackpack", "blacklisted_items");
                        return !(stack.func_77973_b() instanceof TravelersBackpackItem) && !stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_241834_b(blacklistedItems));
                    }
                });
            }
        }
    }

    public void addCraftResult() {
        this.func_75146_a((Slot)new CraftingResultSlot(this.playerInventory.field_70458_d, (CraftingInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 226, 97));
    }

    public void addBackpackInventory(ITravelersBackpackInventory inventory) {
        int j;
        int i;
        int slot = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                this.func_75146_a((Slot)new BackpackSlotItemHandler((IItemHandler)inventory.getInventory(), slot++, 62 + j * 18, 7 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.func_75146_a((Slot)new BackpackSlotItemHandler((IItemHandler)inventory.getInventory(), slot++, 62 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(PlayerInventory playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 44 + x * 18, 125 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 44 + x * 18, 183));
        }
    }

    public void addFluidSlots(ITravelersBackpackInventory inventory) {
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, 41, 6, 7));
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, 42, 6, 37));
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, 43, 226, 7));
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, 44, 226, 37));
    }

    public void addToolSlots(ITravelersBackpackInventory inventory) {
        this.func_75146_a((Slot)new ToolSlotItemHandler(this.playerInventory.field_70458_d, inventory, 39, 44, 79));
        this.func_75146_a((Slot)new ToolSlotItemHandler(this.playerInventory.field_70458_d, inventory, 40, 44, 97));
    }

    public void func_75130_a(IInventory inventory) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.disableCrafting.get()).booleanValue()) {
            CraftingInventoryImproved craftMatrix = this.craftMatrix;
            CraftResultInventory craftResult = this.craftResult;
            World world = this.playerInventory.field_70458_d.field_70170_p;
            if (!world.field_72995_K) {
                ICraftingRecipe icraftingrecipe;
                ServerPlayerEntity player = (ServerPlayerEntity)this.playerInventory.field_70458_d;
                ItemStack itemstack = ItemStack.field_190927_a;
                Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftMatrix, world);
                if (optional.isPresent() && craftResult.func_201561_a(world, player, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                    itemstack = icraftingrecipe.func_77572_b((IInventory)craftMatrix);
                }
                craftResult.func_70299_a(0, itemstack);
                player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, itemstack));
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack result = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (index >= 0 && index <= 54) {
                if (index == 0) {
                    stack.func_77973_b().func_77622_d(stack, player.field_70170_p, player);
                    if (!this.func_75135_a(stack, 55, 91, true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack, result);
                    this.craftMatrix.func_70296_d();
                } else if (!this.func_75135_a(stack, 55, 91, true)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (index >= 55) {
                if (ToolSlotItemHandler.isValid(stack) && !this.func_75135_a(stack, 49, 51, false) && !this.func_75135_a(stack, 10, 49, false) && !this.func_75135_a(stack, 1, 10, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, 10, 49, false) && !this.func_75135_a(stack, 1, 10, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return result;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.inventory.getScreenID() != 3) {
            this.inventory.markDirty();
        }
        this.playSound(playerIn, this.inventory);
        TravelersBackpackBaseContainer.clearBucketSlots(playerIn, this.inventory);
    }

    public static void clearBucketSlots(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn) {
        if (inventoryIn.getScreenID() == 1 && playerIn.func_184614_ca().func_77973_b() instanceof TravelersBackpackItem || inventoryIn.getScreenID() == 2 && CapabilityUtils.getWearingBackpack(playerIn).func_77973_b() instanceof TravelersBackpackItem) {
            for (int i = 41; i <= 44; ++i) {
                TravelersBackpackBaseContainer.clearBucketSlot(playerIn, inventoryIn, i);
            }
        }
    }

    public static void clearBucketSlot(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn, int index) {
        if (!inventoryIn.getInventory().getStackInSlot(index).func_190926_b()) {
            if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                ItemStack stack = inventoryIn.getInventory().getStackInSlot(index).func_77946_l();
                inventoryIn.getInventory().setStackInSlot(index, ItemStack.field_190927_a);
                playerIn.func_71019_a(stack, false);
            } else {
                ItemStack stack = inventoryIn.getInventory().getStackInSlot(index);
                inventoryIn.getInventory().setStackInSlot(index, ItemStack.field_190927_a);
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, stack);
            }
        }
    }

    public void playSound(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn) {
        for (int i = 41; i <= 44; ++i) {
            if (inventoryIn.getInventory().getStackInSlot(i).func_190926_b()) continue;
            playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, (1.0f + (playerIn.field_70170_p.field_73012_v.nextFloat() - playerIn.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            break;
        }
    }
}

