/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container.slot;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.ToolItem;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ToolSlotItemHandler
extends SlotItemHandler {
    private final PlayerEntity player;
    private final ITravelersBackpackInventory inventory;

    public ToolSlotItemHandler(PlayerEntity player, ITravelersBackpackInventory inventoryIn, int index, int xPosition, int yPosition) {
        super((IItemHandler)inventoryIn.getInventory(), index, xPosition, yPosition);
        this.player = player;
        this.inventory = inventoryIn;
    }

    public boolean func_75214_a(ItemStack stack) {
        return ToolSlotItemHandler.isValid(stack);
    }

    public static boolean isValid(ItemStack stack) {
        ResourceLocation acceptableToolsTag = new ResourceLocation("travelersbackpack", "acceptable_tools");
        if (stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_241834_b(acceptableToolsTag))) {
            return true;
        }
        if (stack.func_77976_d() == 1) {
            if (((Boolean)TravelersBackpackConfig.SERVER.toolSlotsAcceptSwords.get()).booleanValue() && stack.func_77973_b() instanceof SwordItem) {
                return true;
            }
            return stack.func_77973_b() instanceof TieredItem || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof HoeItem || stack.func_77973_b() instanceof FishingRodItem || stack.func_77973_b() instanceof ShearsItem || stack.func_77973_b() instanceof FlintAndSteelItem;
        }
        return false;
    }

    public void func_75218_e() {
        super.func_75218_e();
        if (this.inventory.getScreenID() == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }
}

