/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.tileentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModTileEntityTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TravelersBackpackTileEntity
extends TileEntity
implements ITravelersBackpackInventory,
INamedContainerProvider {
    private final ItemStackHandler inventory = this.createHandler(45);
    private final ItemStackHandler craftingInventory = this.createHandler(9);
    private final FluidTank leftTank;
    private final FluidTank rightTank;
    private boolean isSleepingBagDeployed;
    private int color;
    private int lastTime;
    private final LazyOptional<IItemHandlerModifiable> inventoryCapability;
    private final LazyOptional<ItemStackHandler> craftingInventoryCapability;
    private final LazyOptional<IFluidHandler> leftFluidTankCapability;
    private final LazyOptional<IFluidHandler> rightFluidTankCapability;
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String SLEEPING_BAG = "SleepingBag";
    private final String COLOR = "Color";
    private final String LAST_TIME = "LastTime";

    public TravelersBackpackTileEntity() {
        super((TileEntityType)ModTileEntityTypes.TRAVELERS_BACKPACK.get());
        this.leftTank = this.createFluidHandler((Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get());
        this.rightTank = this.createFluidHandler((Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get());
        this.isSleepingBagDeployed = false;
        this.color = 0;
        this.lastTime = 0;
        this.inventoryCapability = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 39));
        this.craftingInventoryCapability = LazyOptional.of(() -> this.craftingInventory);
        this.leftFluidTankCapability = LazyOptional.of(() -> this.leftTank);
        this.rightFluidTankCapability = LazyOptional.of(() -> this.rightTank);
        this.INVENTORY = "Inventory";
        this.CRAFTING_INVENTORY = "CraftingInventory";
        this.LEFT_TANK = "LeftTank";
        this.RIGHT_TANK = "RightTank";
        this.SLEEPING_BAG = "SleepingBag";
        this.COLOR = "Color";
        this.LAST_TIME = "LastTime";
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.saveAllData(compound);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadAllData(nbt);
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveTanks(CompoundNBT compound) {
        compound.func_218657_a("LeftTank", (INBT)this.leftTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("RightTank", (INBT)this.rightTank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    @Override
    public void saveColor(CompoundNBT compound) {
        compound.func_74768_a("Color", this.color);
    }

    @Override
    public void loadColor(CompoundNBT compound) {
        this.color = compound.func_74762_e("Color");
    }

    public PlayerEntity getUsingPlayer() {
        for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b(3.0, 3.0, 3.0))) {
            if (!(player.field_71070_bA instanceof TravelersBackpackTileContainer)) continue;
            return player;
        }
        return null;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 41, this.getUsingPlayer()) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43, this.getUsingPlayer());
    }

    @Override
    public void markTankDirty() {
    }

    @Override
    public void saveItems(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("CraftingInventory", (INBT)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.craftingInventory.deserializeNBT(compound.func_74775_l("CraftingInventory"));
    }

    @Override
    public void saveTime(CompoundNBT compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundNBT compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    public void saveSleepingBag(CompoundNBT compound) {
        compound.func_74757_a("SleepingBag", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(CompoundNBT compound) {
        this.isSleepingBagDeployed = compound.func_74767_n("SleepingBag");
    }

    @Override
    public void saveAllData(CompoundNBT compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveSleepingBag(compound);
        this.saveTime(compound);
        this.saveColor(compound);
    }

    @Override
    public void loadAllData(CompoundNBT compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadSleepingBag(compound);
        this.loadTime(compound);
        this.loadColor(compound);
    }

    @Override
    public CompoundNBT getTagCompound(ItemStack stack) {
        return null;
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        ItemStack stack = ItemStackUtils.getAndSplit((IItemHandler)this.inventory, index, count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        if (block instanceof TravelersBackpackBlock) {
            return new ItemStack((IItemProvider)block);
        }
        return new ItemStack((IItemProvider)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get());
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(World world, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        Direction direction = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && world.func_175623_d(sleepingBagPos2 = (sleepingBagPos1 = pos.func_177972_a(direction)).func_177972_a(direction)) && world.func_175623_d(sleepingBagPos1) && world.func_180495_p(sleepingBagPos1.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos1.func_177977_b(), Direction.UP) && world.func_180495_p(sleepingBagPos2.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos2.func_177977_b(), Direction.UP)) {
            world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
            if (!world.field_72995_K) {
                world.func_175656_a(sleepingBagPos1, (BlockState)((BlockState)((Block)ModBlocks.SLEEPING_BAG.get()).func_176223_P().func_206870_a((Property)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.FOOT));
                world.func_175656_a(sleepingBagPos2, (BlockState)((BlockState)((Block)ModBlocks.SLEEPING_BAG.get()).func_176223_P().func_206870_a((Property)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.HEAD));
                world.func_195593_d(pos, (Block)ModBlocks.SLEEPING_BAG.get());
                world.func_195593_d(sleepingBagPos2, (Block)ModBlocks.SLEEPING_BAG.get());
            }
            this.isSleepingBagDeployed = true;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(World world) {
        Direction blockFacing = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            BlockPos sleepingBagPos1 = this.field_174879_c.func_177972_a(blockFacing);
            BlockPos sleepingBagPos2 = sleepingBagPos1.func_177972_a(blockFacing);
            if (world.func_180495_p(sleepingBagPos1).func_177230_c() == ModBlocks.SLEEPING_BAG.get() && world.func_180495_p(sleepingBagPos2).func_177230_c() == ModBlocks.SLEEPING_BAG.get()) {
                world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
                world.func_175656_a(sleepingBagPos2, Blocks.field_150350_a.func_176223_P());
                world.func_175656_a(sleepingBagPos1, Blocks.field_150350_a.func_176223_P());
                this.isSleepingBagDeployed = false;
                this.func_70296_d();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c() == ModBlocks.SLEEPING_BAG.get() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction).func_177972_a(direction)).func_177230_c() == ModBlocks.SLEEPING_BAG.get()) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public Direction getBlockDirection(TileEntity tile) {
        if (tile instanceof TravelersBackpackTileEntity) {
            if (this.field_145850_b == null || !(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof TravelersBackpackBlock)) {
                return Direction.NORTH;
            }
            return (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)TravelersBackpackBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean drop(World world, BlockPos pos, Item item) {
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        this.transferToItemStack(stack);
        ItemEntity droppedItem = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        return world.func_217376_c((Entity)droppedItem);
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveTime(compound);
        if (this.hasColor()) {
            this.saveColor(compound);
        }
        stack.func_77982_d(compound);
        return stack;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyBlockUpdate();
    }

    private void notifyBlockUpdate() {
        BlockState blockstate = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.field_145850_b.func_225319_b(this.field_174879_c, blockstate, blockstate);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockstate, blockstate, 3);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void openGUI(PlayerEntity player, INamedContainerProvider containerSupplier, BlockPos pos) {
        if (!player.field_70170_p.field_72995_K && this.getUsingPlayer() == null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerSupplier, (BlockPos)pos);
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new TravelersBackpackTileContainer(id, inventory, this);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ResourceLocation blacklistedItems = new ResourceLocation("travelersbackpack", "blacklisted_items");
                return !(stack.func_77973_b() instanceof TravelersBackpackItem) && !stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_241834_b(blacklistedItems));
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackTileEntity.this.func_70296_d();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction direction = this.getBlockDirection(this.getTileEntity());
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapability.cast();
            }
            switch (side) {
                case DOWN: 
                case UP: {
                    return this.inventoryCapability.cast();
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    if (side != direction && side != direction.func_176734_d()) break;
                    return this.craftingInventoryCapability.cast();
                }
            }
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.leftFluidTankCapability.cast();
            }
            if (direction == Direction.NORTH) {
                switch (side) {
                    case WEST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case EAST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.SOUTH) {
                switch (side) {
                    case EAST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case WEST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.EAST) {
                switch (side) {
                    case NORTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case SOUTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.WEST) {
                switch (side) {
                    case SOUTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case NORTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapability.invalidate();
        this.craftingInventoryCapability.invalidate();
        this.leftFluidTankCapability.invalidate();
        this.rightFluidTankCapability.invalidate();
    }
}

