/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import com.ocelot.vehicle.jei.VehicleModJei;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class FluidMixerCategory
implements IRecipeCategory<FluidMixerRecipe> {
    public static final int BAR_HORIZONTAL = 12;
    public static final int BAR_VERTICAL = 8;
    public static final int MIX_HORIZONTAL = 76;
    public static final int JUNCTION_SIZE = 10;
    public static final int SUM_LENGTH = 116;
    public static final int FLUID_ALPHA = 130;
    private final IDrawableStatic progressBackgroundMask;
    private final IDrawableStatic progressMask;
    private final ITickTimer progress;
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic inputOverlay;
    private final IDrawableStatic outputOverlay;
    private final String localizedName;

    public FluidMixerCategory(IGuiHelper guiHelper) {
        this.progressBackgroundMask = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 17, 76, 26);
        this.progressMask = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 65, 20, 76, 26);
        this.progress = guiHelper.createTickTimer(100, 100, false);
        IDrawableStatic staticFlame = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 0, 14, 14);
        this.background = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 0, 0, 160, 66);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_MIXER.get()));
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.inputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 29);
        this.outputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 59);
        this.localizedName = I18n.func_135052_a((String)"jev.category.fluid_mixing.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FluidMixerRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.getIngredient());
        ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(recipe.getInputs()[0].createStack(), recipe.getInputs()[1].createStack()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getResult().createStack());
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VehicleModJei.FLUID_MIXER_UID;
    }

    public Class<? extends FluidMixerRecipe> getRecipeClass() {
        return FluidMixerRecipe.class;
    }

    public void draw(FluidMixerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int alpha;
        double percentageJunction;
        this.animatedFlame.draw(matrixStack, 1, 15);
        int fluidInput1Color = FluidUtils.getAverageFluidColor((Fluid)recipe.getInputs()[0].getFluid());
        int fluidInput2Color = FluidUtils.getAverageFluidColor((Fluid)recipe.getInputs()[1].getFluid());
        int fluidOutputColor = FluidUtils.getAverageFluidColor((Fluid)recipe.getResult().getFluid());
        int startColor = FluidMixerCategory.averageColor(fluidInput1Color, fluidInput2Color);
        double progressPercentage = (double)this.progress.getValue() / (double)this.progress.getMaxValue();
        double percentagePrevious = 0.0;
        double percentageBarHorizontal = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.10344827586206896), (double)0.0, (double)1.0);
        percentagePrevious += 0.10344827586206896;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)43, (int)11, (int)(43 + (int)(percentageBarHorizontal * 12.0)), (int)19, (int)(0x82000000 | fluidInput1Color));
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)43, (int)47, (int)(43 + (int)(percentageBarHorizontal * 12.0)), (int)55, (int)(0x82000000 | fluidInput2Color));
        if (progressPercentage >= percentagePrevious) {
            percentageJunction = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.08620689655172414), (double)0.0, (double)1.0);
            percentagePrevious += 0.08620689655172414;
            alpha = (int)(130.0 * percentageJunction);
            int fluidInput1JunctionColor = alpha << 24 | fluidInput1Color;
            int fluidInput2JunctionColor = alpha << 24 | fluidInput2Color;
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)55, (int)10, (int)65, (int)20, (int)fluidInput1JunctionColor);
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)55, (int)46, (int)65, (int)56, (int)fluidInput2JunctionColor);
        }
        if (progressPercentage >= percentagePrevious) {
            double percentageBarVertical = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.06896551724137931), (double)0.0, (double)1.0);
            percentagePrevious += 0.06896551724137931;
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)56, (int)20, (int)64, (int)(20 + (int)(percentageBarVertical * 8.0)), (int)(0x82000000 | fluidInput1Color));
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)56, (int)(46 - (int)(percentageBarVertical * 8.0)), (int)64, (int)46, (int)(0x82000000 | fluidInput2Color));
        }
        if (progressPercentage >= percentagePrevious) {
            percentageJunction = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.08620689655172414), (double)0.0, (double)1.0);
            percentagePrevious += 0.08620689655172414;
            alpha = (int)(130.0 * percentageJunction);
            int color = alpha << 24 | startColor;
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)55, (int)28, (int)65, (int)38, (int)color);
        }
        if (progressPercentage >= percentagePrevious) {
            double percentageMix = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.6551724137931034), (double)0.0, (double)1.0);
            RenderSystem.disableDepthTest();
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
            RenderUtil.drawGradientRectHorizontal((int)65, (int)20, (int)141, (int)46, (int)(0x82000000 | startColor), (int)(0x82000000 | fluidOutputColor));
            RenderSystem.popMatrix();
            this.progressBackgroundMask.draw(matrixStack, 65, 20);
            this.progressMask.draw(matrixStack, 65, 20, 0, 0, (int)(percentageMix * 76.0), 0);
            RenderSystem.enableDepthTest();
        }
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull FluidMixerRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 94, 24);
        fluids.init(0, true, 25, 1, 16, 29, 5000, false, (IDrawable)this.inputOverlay);
        fluids.init(1, true, 25, 36, 16, 29, 5000, false, (IDrawable)this.inputOverlay);
        fluids.init(2, false, 143, 4, 16, 59, 10000, false, (IDrawable)this.outputOverlay);
        stacks.set(ingredients);
        fluids.set(ingredients);
    }

    private static int averageColor(int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return (a1 + a2) / 2 << 24 | (r1 + r2) / 2 << 16 | (g1 + g2) / 2 << 8 | (b1 + b2) / 2;
    }
}

