/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.item.EngineItem;
import com.mrcrayfish.vehicle.item.WheelItem;
import com.ocelot.vehicle.jei.VehicleModJei;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.registries.ForgeRegistries;

public class VehicleCategory
implements IRecipeCategory<VehicleRecipe> {
    private static final int MATERIAL_SLOTS = 8;
    private static final float SCALE = 20.0f;
    private static final Item[] DYES = (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeItem).toArray(Item[]::new);
    private static final Item[] ENGINES = (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof EngineItem).toArray(Item[]::new);
    private static final Item[] WHEELS = (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof WheelItem).toArray(Item[]::new);
    private static final Map<EntityType<?>, Entity> VEHICLES = new WeakHashMap();
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableStatic shadow;
    private final IDrawableStatic slot;
    private final IDrawableStatic slotIconNone;
    private final String localizedName;

    public VehicleCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(144, 113);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.WORKSTATION.get()));
        this.shadow = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 112, 74, 90, 10);
        this.slot = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 43, 18, 18);
        this.slotIconNone = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 194, 43, 16, 16);
        this.localizedName = I18n.func_135052_a((String)"jev.category.vehicle.title", (Object[])new Object[0]);
    }

    @Nullable
    private static Entity getEntity(VehicleRecipe recipe) {
        return VEHICLES.computeIfAbsent(recipe.getVehicle(), key -> key.func_200721_a((World)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e)));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(VehicleRecipe recipe, IIngredients ingredients) {
        Entity entity = VehicleCategory.getEntity(recipe);
        ArrayList itemInputs = new ArrayList();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (vehicle.canBeColored()) {
                itemInputs.add(Arrays.stream(DYES).map(ItemStack::new).collect(Collectors.toList()));
            } else {
                itemInputs.add(Collections.emptyList());
            }
        } else {
            itemInputs.add(Collections.emptyList());
        }
        if (entity instanceof PoweredVehicleEntity) {
            PoweredVehicleEntity poweredVehicle = (PoweredVehicleEntity)entity;
            poweredVehicle.setEngine(true);
            poweredVehicle.setWheels(true);
            poweredVehicle.setEngineTier(EngineTier.WOOD);
            if (poweredVehicle.getEngineType() != EngineType.NONE) {
                itemInputs.add(Arrays.stream(ENGINES).filter(item -> ((EngineItem)item).getEngineType() == poweredVehicle.getEngineType()).map(ItemStack::new).collect(Collectors.toList()));
            } else {
                itemInputs.add(Collections.emptyList());
            }
            if (poweredVehicle.canChangeWheels()) {
                itemInputs.add(Arrays.stream(WHEELS).map(ItemStack::new).collect(Collectors.toList()));
            } else {
                itemInputs.add(Collections.emptyList());
            }
        } else {
            itemInputs.add(Collections.emptyList());
            itemInputs.add(Collections.emptyList());
        }
        recipe.getMaterials().forEach(material -> itemInputs.add(Collections.singletonList(material.func_77946_l())));
        ingredients.setInputLists(VanillaTypes.ITEM, itemInputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)BlockVehicleCrate.create((ResourceLocation)Objects.requireNonNull(recipe.getVehicle().getRegistryName()), (int)0, null, null, (int)0));
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VehicleModJei.VEHICLE_UID;
    }

    public Class<? extends VehicleRecipe> getRecipeClass() {
        return VehicleRecipe.class;
    }

    public void draw(VehicleRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.shadow.draw(matrixStack, 27, 45);
        RenderSystem.disableBlend();
        this.slot.draw(matrixStack, 0, 64);
        this.slot.draw(matrixStack, 20, 64);
        this.slot.draw(matrixStack, 40, 64);
        this.slot.draw(matrixStack, 126, 64);
        Entity vehicle = VehicleCategory.getEntity(recipe);
        if (!SlotType.COLOR.isApplicable(vehicle)) {
            this.slotIconNone.draw(matrixStack, 1, 65);
        }
        if (!SlotType.ENGINE.isApplicable(vehicle)) {
            this.slotIconNone.draw(matrixStack, 21, 65);
        }
        if (!SlotType.WHEELS.isApplicable(vehicle)) {
            this.slotIconNone.draw(matrixStack, 41, 65);
        }
        for (int i = 0; i < 8; ++i) {
            this.slot.draw(matrixStack, i * 18, 95);
        }
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)"jev.category.vehicle.materials", (Object[])new Object[0]), 0.0f, 85.0f, 0x404040);
        if (vehicle == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)72.0f, (float)50.0f, (float)1050.0f);
        RenderSystem.scalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        MatrixStack ms = new MatrixStack();
        ms.func_227861_a_(0.0, 0.0, 1000.0);
        ms.func_227862_a_(20.0f, 20.0f, 20.0f);
        Quaternion quaternion = Vector3f.field_229178_a_.func_229187_a_(5.0f);
        Quaternion quaternion1 = Vector3f.field_229180_c_.func_229187_a_((float)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_70173_aa + Animation.getPartialTickTime());
        quaternion.func_195890_a(quaternion1);
        ms.func_227863_a_(quaternion);
        VehicleProperties properties = VehicleProperties.getProperties((EntityType)recipe.getVehicle());
        PartPosition position = PartPosition.DEFAULT;
        if (properties != null) {
            position = properties.getDisplayPosition();
        }
        ms.func_227862_a_((float)position.getScale(), (float)position.getScale(), (float)position.getScale());
        ms.func_227863_a_(Axis.POSITIVE_X.func_229187_a_((float)position.getRotX()));
        ms.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)position.getRotY()));
        ms.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_((float)position.getRotZ()));
        ms.func_227861_a_(position.getX(), position.getY(), position.getZ());
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.func_178633_a(false);
        renderManager.func_229089_a_(quaternion);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> renderManager.func_229084_a_(vehicle, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0));
        renderTypeBuffer.func_228461_a_();
        renderManager.func_178633_a(true);
        ms.func_227865_b_();
        RenderSystem.popMatrix();
    }

    @Nonnull
    public List<ITextComponent> getTooltipStrings(VehicleRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        for (int i = 0; i < SlotType.values().length; ++i) {
            this.addSlotTooltip(tooltip, i * 20, recipe, mouseX, mouseY, SlotType.values()[i]);
        }
        return tooltip;
    }

    private void addSlotTooltip(List<ITextComponent> tooltip, int slotX, VehicleRecipe recipe, double mouseX, double mouseY, SlotType type) {
        if (type.isApplicable(VehicleCategory.getEntity(recipe))) {
            return;
        }
        if (mouseX >= (double)slotX && mouseX < (double)(slotX + 18) && mouseY >= 64.0 && mouseY < 82.0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("vehicle.tooltip." + type.registryName));
            tooltip.add((ITextComponent)new TranslationTextComponent("vehicle.tooltip.not_applicable"));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull VehicleRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        for (i = 0; i < SlotType.values().length; ++i) {
            stacks.init(i, true, i * 20, 64);
        }
        stacks.init(3, false, 126, 64);
        for (i = 0; i < ingredients.getInputs(VanillaTypes.ITEM).size(); ++i) {
            stacks.init(4 + i, true, i % 8 * 18, 95 + i / 8 * 18);
        }
        stacks.set(ingredients);
    }

    private static enum SlotType {
        COLOR("paint_color", VehicleEntity::canBeColored),
        ENGINE("engine", vehicle -> vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).getEngineType() != EngineType.NONE),
        WHEELS("wheels", vehicle -> vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).canChangeWheels());

        private final String registryName;
        private final Predicate<VehicleEntity> applicable;

        private SlotType(String registryName, Predicate<VehicleEntity> applicable) {
            this.registryName = registryName;
            this.applicable = applicable;
        }

        private boolean isApplicable(@Nullable Entity entity) {
            return entity instanceof VehicleEntity && this.applicable.test((VehicleEntity)entity);
        }
    }
}

