/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mrcrayfish.vehicle.client.screen.FluidExtractorScreen;
import com.mrcrayfish.vehicle.client.screen.FluidMixerScreen;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.inventory.container.FluidExtractorContainer;
import com.mrcrayfish.vehicle.inventory.container.FluidMixerContainer;
import com.ocelot.vehicle.jei.VehicleModJei;
import com.ocelot.vehicle.jei.plugin.FluidExtractorCategory;
import com.ocelot.vehicle.jei.plugin.FluidMixerCategory;
import com.ocelot.vehicle.jei.plugin.VehicleCategory;
import com.ocelot.vehicle.jei.plugin.VehicleRecipeValidator;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class VehicleModJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jev", "vehicle");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(((Block)ModBlocks.VEHICLE_CRATE.get()).func_199767_j(), stack -> {
            if (stack.func_179543_a("BlockEntityTag") != null) {
                CompoundNBT blockEntityTag = stack.func_179543_a("BlockEntityTag");
                return blockEntityTag != null ? blockEntityTag.func_74779_i("Vehicle") : "";
            }
            return "";
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidExtractorCategory(guiHelper), new FluidMixerCategory(guiHelper), new VehicleCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        VehicleRecipeValidator.Results recipes = VehicleRecipeValidator.getValidRecipes();
        registration.addRecipes(recipes.getFluidExtractorRecipes(), VehicleModJei.FLUID_EXTRACTOR_UID);
        registration.addRecipes(recipes.getFluidMixerRecipes(), VehicleModJei.FLUID_MIXER_UID);
        registration.addRecipes(recipes.getVehicleRecipes(), VehicleModJei.VEHICLE_UID);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FluidExtractorScreen.class, 93, 35, 24, 17, new ResourceLocation[]{VehicleModJei.FLUID_EXTRACTOR_UID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeClickArea(FluidMixerScreen.class, 51, 26, 47, 46, new ResourceLocation[]{VehicleModJei.FLUID_MIXER_UID, VanillaRecipeCategoryUid.FUEL});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_EXTRACTOR.get()), new ResourceLocation[]{VehicleModJei.FLUID_EXTRACTOR_UID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_MIXER.get()), new ResourceLocation[]{VehicleModJei.FLUID_MIXER_UID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKSTATION.get()), new ResourceLocation[]{VehicleModJei.VEHICLE_UID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FluidExtractorContainer.class, VehicleModJei.FLUID_EXTRACTOR_UID, 1, 1, 2, 36);
        registration.addRecipeTransferHandler(FluidMixerContainer.class, VehicleModJei.FLUID_MIXER_UID, 1, 1, 2, 36);
    }
}

