/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.crafting.FluidExtractorRecipe;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VehicleRecipeValidator {
    private static final Logger LOGGER = LogManager.getLogger();

    private VehicleRecipeValidator() {
    }

    public static Results getValidRecipes() {
        Results results = new Results();
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe<?> recipe : VehicleRecipeValidator.getRecipes(recipeManager, RecipeType.FLUID_EXTRACTOR)) {
            if (!(recipe instanceof FluidExtractorRecipe)) continue;
            FluidExtractorRecipe extractorRecipe = (FluidExtractorRecipe)recipe;
            if (extractorRecipe.getIngredient().func_190926_b()) {
                LOGGER.error("Recipe has no input. {}", (Object)recipe.func_199560_c());
                continue;
            }
            if (extractorRecipe.getResult().createStack().isEmpty()) {
                LOGGER.error("Recipe has no output. {}", (Object)recipe.func_199560_c());
                continue;
            }
            results.fluidExtractorRecipes.add(extractorRecipe);
        }
        for (IRecipe<?> recipe : VehicleRecipeValidator.getRecipes(recipeManager, RecipeType.FLUID_MIXER)) {
            if (!(recipe instanceof FluidMixerRecipe)) continue;
            FluidMixerRecipe mixerRecipe = (FluidMixerRecipe)recipe;
            if (mixerRecipe.getInputs().length != 2) {
                LOGGER.error("Recipe has too many inputs. {}", (Object)recipe.func_199560_c());
                continue;
            }
            boolean singleInput = false;
            for (FluidEntry entry : mixerRecipe.getInputs()) {
                if (entry.createStack().isEmpty()) continue;
                singleInput = true;
                break;
            }
            if (!singleInput) {
                LOGGER.error("Recipe has no inputs. {}", (Object)recipe.func_199560_c());
                continue;
            }
            if (mixerRecipe.getResult().createStack().isEmpty()) {
                LOGGER.error("Recipe has no output. {}", (Object)recipe.func_199560_c());
                continue;
            }
            results.fluidMixerRecipes.add(mixerRecipe);
        }
        for (IRecipe<?> recipe : VehicleRecipeValidator.getRecipes(recipeManager, RecipeType.CRAFTING)) {
            if (!(recipe instanceof VehicleRecipe)) continue;
            VehicleRecipe vehicleRecipe = (VehicleRecipe)recipe;
            if (vehicleRecipe.getMaterials().isEmpty()) {
                LOGGER.error("Recipe has no inputs. {}", (Object)recipe.func_199560_c());
                continue;
            }
            if (vehicleRecipe.getVehicle() == null) {
                LOGGER.error("Recipe has no output. {}", (Object)recipe.func_199560_c());
                continue;
            }
            results.vehicleRecipes.add(vehicleRecipe);
        }
        return results;
    }

    private static Collection<IRecipe<?>> getRecipes(RecipeManager recipeManager, IRecipeType<?> recipeType) {
        return recipeManager.func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == recipeType).collect(Collectors.toSet());
    }

    public static class Results {
        private final List<FluidExtractorRecipe> fluidExtractorRecipes = new ArrayList<FluidExtractorRecipe>();
        private final List<FluidMixerRecipe> fluidMixerRecipes = new ArrayList<FluidMixerRecipe>();
        private final List<VehicleRecipe> vehicleRecipes = new ArrayList<VehicleRecipe>();

        public List<FluidExtractorRecipe> getFluidExtractorRecipes() {
            return this.fluidExtractorRecipes;
        }

        public List<FluidMixerRecipe> getFluidMixerRecipes() {
            return this.fluidMixerRecipes;
        }

        public List<VehicleRecipe> getVehicleRecipes() {
            return this.vehicleRecipes;
        }
    }
}

