/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.api.jei;

import com.phylogeny.extrabitmanipulation.api.jei.JustEnoughItemsPlugin;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class InfoRecipeBase
implements IRecipeWrapper {
    protected List<ItemStack> itemStacks;
    protected List<String> tooltipLines = new ArrayList<String>();
    protected ResourceLocation image;
    protected int imageWidth;
    protected int imageHeight;
    protected IDrawable slotDrawable;
    protected String name;
    protected String text;
    protected Rectangle imageBox;

    public InfoRecipeBase(IGuiHelper guiHelper, List<ItemStack> itemStacks, int imageWidth, int imageHeight, String recipeName, String imageName, String tooltipName, int imageLeft, int imageTop, int imageRight, int imageBottom, String catagoryName) {
        this.itemStacks = itemStacks;
        this.image = new ResourceLocation("extrabitmanipulation", "textures/jei/images/" + imageName + ".png");
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.name = JustEnoughItemsPlugin.translate(catagoryName + ".name." + recipeName);
        String toolTip = ".tooltip";
        if (!tooltipName.contains(".")) {
            tooltipName = tooltipName + ".";
        } else {
            toolTip = toolTip + ".";
        }
        tooltipName = tooltipName.replaceFirst("[.]", toolTip);
        this.tooltipLines.addAll(Arrays.asList(JustEnoughItemsPlugin.translate(tooltipName).split("\\\\n")));
        this.text = JustEnoughItemsPlugin.translate(tooltipName.replace("tooltip", "text"));
        this.imageBox = new Rectangle(imageLeft, imageTop, imageRight - imageLeft, imageBottom - imageTop);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, Collections.singletonList(this.itemStacks));
        ingredients.setOutputs(ItemStack.class, this.itemStacks);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> getTooltips = new ArrayList<String>();
        if (this.imageBox.contains(mouseX, mouseY)) {
            getTooltips.addAll(this.tooltipLines);
        }
        return getTooltips;
    }

    protected String translateName(String catagoryName, String name) {
        return JustEnoughItemsPlugin.translate(catagoryName + ".name." + name);
    }
}

