/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketArmorSlotInt
implements IMessage {
    protected ItemChiseledArmor.ArmorType armorType;
    protected int indexArmorSet;
    protected int value;

    public PacketArmorSlotInt() {
    }

    public PacketArmorSlotInt(@Nullable ItemChiseledArmor.ArmorType armorType, int indexArmorSet, int value) {
        this.armorType = armorType;
        this.indexArmorSet = indexArmorSet;
        this.value = value;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.value);
        buffer.writeInt(this.indexArmorSet);
        if (BitIOHelper.notNullToBuffer(buffer, (Object)this.armorType)) {
            buffer.writeInt(this.armorType.ordinal());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.value = buffer.readInt();
        this.indexArmorSet = buffer.readInt();
        if (buffer.readBoolean()) {
            this.armorType = ItemChiseledArmor.ArmorType.values()[buffer.readInt()];
        }
    }

    protected static ItemStack getArmorStack(EntityPlayer player, PacketArmorSlotInt message) {
        ItemStack stack = ItemStackHelper.getChiseledArmorStack(player, message.armorType, message.indexArmorSet);
        return ItemStackHelper.isChiseledArmorStack(stack) ? stack : ItemStack.field_190927_a;
    }
}

