/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;

public final class BaubleRenderHandler
implements LayerRenderer<EntityPlayer> {
    public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!ConfigHandler.renderBaubles || player.func_70660_b(MobEffects.field_76441_p) != null) {
            return;
        }
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        this.dispatchRenders((IItemHandler)inv, player, IBaubleRender.RenderType.BODY, partialTicks);
        if (!inv.getStackInSlot(3).func_190926_b()) {
            this.renderManaTablet(player);
        }
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        this.dispatchRenders((IItemHandler)inv, player, IBaubleRender.RenderType.HEAD, partialTicks);
        ItemStack helm = player.field_71071_by.func_70440_f(3);
        if (!helm.func_190926_b() && helm.func_77973_b() instanceof ItemTerrasteelHelm) {
            ItemTerrasteelHelm.renderOnPlayer(helm, player);
        }
        GlStateManager.func_179121_F();
    }

    private void dispatchRenders(IItemHandler inv, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ICosmeticAttachable attachable;
            ItemStack cosmetic;
            IPhantomInkable inkable;
            Item item;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || (item = stack.func_77973_b()) instanceof IPhantomInkable && (inkable = (IPhantomInkable)item).hasPhantomInk(stack)) continue;
            if (item instanceof ICosmeticAttachable && !(cosmetic = (attachable = (ICosmeticAttachable)item).getCosmeticItem(stack)).func_190926_b()) {
                GlStateManager.func_179094_E();
                GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ((IBaubleRender)cosmetic.func_77973_b()).onPlayerBaubleRender(cosmetic, player, type, partialTicks);
                GlStateManager.func_179121_F();
                continue;
            }
            if (!(item instanceof IBaubleRender)) continue;
            GlStateManager.func_179094_E();
            GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ((IBaubleRender)stack.func_77973_b()).onPlayerBaubleRender(stack, player, type, partialTicks);
            GlStateManager.func_179121_F();
        }
    }

    private void renderManaTablet(EntityPlayer player) {
        boolean renderedOne = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.manaTablet) continue;
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            IBaubleRender.Helper.rotateIfSneaking(player);
            boolean armor = !player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)0.0);
            GlStateManager.func_179139_a((double)0.55, (double)0.55, (double)0.55);
            if (renderedOne) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(armor ? 0.55f : 0.5f));
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(armor ? -0.55f : -0.5f));
            }
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
            if (renderedOne) {
                return;
            }
            renderedOne = true;
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

