/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStem;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAltGrass
extends BlockMod
implements ILexiconable {
    public BlockAltGrass() {
        super(Material.field_151577_b, "altGrass");
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.DRY)));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.ALTGRASS_VARIANT});
    }

    public boolean isToolEffective(String type, @Nonnull IBlockState state) {
        return type.equals("shovel");
    }

    public int func_176201_c(IBlockState state) {
        return ((AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.values()[meta]));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 6; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() instanceof ItemHoe && world.func_175623_d(pos.func_177984_a())) {
            held.func_77972_a(1, (EntityLivingBase)player);
            world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 3);
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state.func_177230_c() == this && world.func_175699_k(pos.func_177984_a()) >= 9) {
            AltGrassVariant variant = (AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT));
            for (int l = 0; l < 4; ++l) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                world.func_180495_p(pos1.func_177984_a()).func_177230_c();
                if (world.func_180495_p(pos1).func_177230_c() != Blocks.field_150346_d || world.func_180495_p(pos1).func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || world.func_175699_k(pos1.func_177984_a()) < 4 || world.getBlockLightOpacity(pos1.func_177984_a()) > 2) continue;
                world.func_180501_a(pos1, this.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)variant)), 3);
            }
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150346_d.func_180660_a(state, rand, fortune);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        EnumPlantType type = plantable.getPlantType(world, pos.func_177977_b());
        return type == EnumPlantType.Plains || type == EnumPlantType.Beach || plantable instanceof BlockStem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random r) {
        if (state.func_177230_c() != this) {
            return;
        }
        AltGrassVariant variant = (AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT));
        switch (variant) {
            case DRY: {
                break;
            }
            case GOLDEN: {
                break;
            }
            case VIVID: {
                break;
            }
            case SCORCHED: {
                if (r.nextInt(80) != 0) break;
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.1, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case INFUSED: {
                if (r.nextInt(100) != 0) break;
                Botania.proxy.sparkleFX((float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 0.0f, 1.0f, 1.0f, r.nextFloat() * 0.2f + 1.0f, 5);
                break;
            }
            case MUTATED: {
                if (r.nextInt(100) != 0) break;
                if (r.nextInt(100) > 25) {
                    Botania.proxy.sparkleFX((float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 1.0f, 0.0f, 1.0f, r.nextFloat() * 0.2f + 1.0f, 5);
                    break;
                }
                Botania.proxy.sparkleFX((float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 1.0f, 1.0f, 0.0f, r.nextFloat() * 0.2f + 1.0f, 5);
            }
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.grassSeeds;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, AltGrassVariant.values().length);
    }
}

