/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.armor.ModelArmorManaweave;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemManaweaveArmor
extends ItemManasteelArmor {
    private static ItemStack[] armorset;

    public ItemManaweaveArmor(EntityEquipmentSlot type, String name) {
        super(type, name, BotaniaAPI.manaweaveArmorMaterial);
        this.func_185043_a(new ResourceLocation("botania", "holiday"), (stack, worldIn, entityIn) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, EntityEquipmentSlot slot) {
        this.models.put(slot, new ModelArmorManaweave(slot));
        return (ModelBiped)this.models.get(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EntityEquipmentSlot slot) {
        return ConfigHandler.enableArmorModels ? (ClientProxy.jingleTheBells ? "botania:textures/model/armor_manaweave_holiday.png" : "botania:textures/model/armor_manaweave.png") : (slot == EntityEquipmentSlot.LEGS ? "botania:textures/model/manaweave_1.png" : "botania:textures/model/manaweave_0.png");
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (ClientProxy.jingleTheBells) {
            name = name.replaceAll("manaweave", "santaweave");
        }
        return name;
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 22 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ModItems.manaweaveHelm), new ItemStack(ModItems.manaweaveChest), new ItemStack(ModItems.manaweaveLegs), new ItemStack(ModItems.manaweaveBoots)};
        }
        return armorset;
    }

    @Override
    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.manaweaveHelm;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.manaweaveChest;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.manaweaveLegs;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.manaweaveBoots;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getArmorSetName() {
        return I18n.func_135052_a((String)"botania.armorset.manaweave.name", (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformationAfterShift(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        if (ClientProxy.jingleTheBells) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.santaweaveInfo", (Object[])new Object[0]), list);
            this.addStringToTooltip("", list);
        }
        super.addInformationAfterShift(stack, world, list, flags);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.manaweave.desc0", (Object[])new Object[0]), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.manaweave.desc1", (Object[])new Object[0]), list);
    }
}

