/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.fog.FogResult;
import org.orecruncher.dsurround.client.handlers.fog.VanillaFogRangeCalculator;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final int DISTANCE = 20;
    protected static final float DUST_FOG_IMPACT = 0.9f;
    protected final Context[] context = new Context[]{new Context(), new Context()};

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        IBlockAccessEx provider = ClientChunkCache.instance();
        int playerX = MathStuff.floor((double)player2.field_70165_t);
        int playerZ = MathStuff.floor((double)player2.field_70161_v);
        float rainStr = Weather.getIntensityLevel();
        Context ctx = this.context[event.getFogMode() == -1 ? 0 : 1];
        if (ctx.returnCached(playerX, playerZ, rainStr, event)) {
            return ctx.cached;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        boolean isRaining = Weather.isRaining();
        ctx.rain = rainStr;
        ctx.doScan = false;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                pos.func_181079_c(playerX + x, 0, playerZ + z);
                ctx.doScan = ctx.doScan | !provider.isAvailable((BlockPos)pos);
                BiomeInfo biome = BiomeUtil.getBiomeData(provider.func_180494_b((BlockPos)pos));
                float distancePart = 1.0f;
                float weightPart = 1.0f;
                if (isRaining && biome.getHasDust()) {
                    distancePart = 1.0f - 0.9f * rainStr;
                } else if (biome.getHasFog()) {
                    distancePart = biome.getFogDensity();
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += 1.0f;
            }
        }
        float weightMixed = 1681.0f;
        float weightDefault = 1681.0f - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float rangeConst = Math.max(240.0f, event.getFarPlaneDistance() - 16.0f);
        float farPlaneDistance = (fpDistanceBiomeFog * rangeConst + event.getFarPlaneDistance() * weightDefault) / 1681.0f;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / 1681.0f;
        ctx.posX = playerX;
        ctx.posZ = playerZ;
        ctx.lastFarPlane = event.getFarPlaneDistance();
        farPlaneDistance = Math.min(farPlaneDistance, event.getFarPlaneDistance());
        ctx.cached.set(event.getFogMode(), farPlaneDistance, farPlaneDistanceScale);
        return ctx.cached;
    }

    private static class Context {
        public int posX;
        public int posZ;
        public float rain;
        public float lastFarPlane;
        public boolean doScan = true;
        public final FogResult cached = new FogResult();

        private Context() {
        }

        public boolean returnCached(int pX, int pZ, float r, @Nonnull EntityViewRenderEvent.RenderFogEvent event) {
            return !this.doScan && pX == this.posX && pZ == this.posZ && r == this.rain && this.lastFarPlane == event.getFarPlaneDistance() && this.cached.isValid(event);
        }
    }
}

