/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class ComposerTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int SLOT_COUNT = 9;
    public static final int SLOT_OUT = 0;
    public static final int SLOT_TABS = 1;
    public static final int SLOT_GHOSTS = 10;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)BuilderSetup.shapeCardItem)}), "container", 0, 18, 200);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)BuilderSetup.shapeCardItem)}), "container", 1, 18, 7, 1, 18, 9, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), "container", 10, 36, 7, 1, 18, 9, 18);
            this.layoutPlayerInventorySlots(85, 142);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 19);
    private ShapeModifier[] modifiers = new ShapeModifier[9];

    public ComposerTileEntity() {
        for (int i = 0; i < this.modifiers.length; ++i) {
            this.modifiers[i] = new ShapeModifier(ShapeOperation.UNION, false, ShapeRotation.NONE);
        }
    }

    public void func_73660_a() {
        ItemStack output;
        if (!this.func_145831_w().field_72995_K && !(output = this.func_70301_a(0)).func_190926_b()) {
            NBTTagList list = new NBTTagList();
            for (int i = 1; i < 10; ++i) {
                ItemStack item = this.func_70301_a(i);
                if (item.func_190926_b() || !item.func_77942_o()) continue;
                NBTTagCompound copy = item.func_77978_p().func_74737_b();
                ShapeModifier modifier = this.modifiers[i - 1];
                ShapeCardItem.setModifier(copy, modifier);
                ItemStack materialGhost = this.func_70301_a(i + 9);
                ShapeCardItem.setGhostMaterial(copy, materialGhost);
                list.func_74742_a((NBTBase)copy);
            }
            ShapeCardItem.setChildren(output, list);
            if (!ShapeCardItem.getShape(output).isComposition()) {
                ShapeCardItem.setShape(output, Shape.SHAPE_COMPOSITION, true);
            }
        }
    }

    public ShapeModifier[] getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(ShapeModifier[] modifiers) {
        this.modifiers = modifiers;
        this.markDirtyClient();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        NBTTagList list = tagCompound.func_150295_c("ops", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ShapeRotation rotation;
            NBTTagCompound tag = list.func_150305_b(i);
            String op = tag.func_74779_i("mod_op");
            boolean flipY = tag.func_74767_n("mod_flipy");
            String rot = tag.func_74779_i("mod_rot");
            ShapeOperation operation = ShapeOperation.getByName(op);
            if (operation == null) {
                operation = ShapeOperation.UNION;
            }
            if ((rotation = ShapeRotation.getByName(rot)) == null) {
                rotation = ShapeRotation.NONE;
            }
            this.modifiers[i] = new ShapeModifier(operation, flipY, rotation);
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = new NBTTagCompound();
            ShapeModifier mod = this.modifiers[i];
            tc.func_74778_a("mod_op", mod.getOperation().getCode());
            tc.func_74757_a("mod_flipy", mod.isFlipY());
            tc.func_74778_a("mod_rot", mod.getRotation().getCode());
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("ops", (NBTBase)list);
    }
}

