/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderRing
extends Render<EntityRing> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/ring.png");

    public RenderRing(RenderManager mgr) {
        super(mgr);
    }

    protected ResourceLocation getEntityTexture(EntityRing entity) {
        return TEXTURE;
    }

    public void doRender(EntityRing entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.setupGL();
        this.func_110776_a(this.getEntityTexture(entity));
        if (entity.facesCamera) {
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (entity.facing != null) {
            float pitch = (float)Math.toDegrees(Math.asin(-entity.facing.field_72448_b));
            float yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)entity.facing.field_72450_a, (double)entity.facing.field_72449_c));
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.renderRing(entity, partialTicks);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderRing(entity, partialTicks);
        this.revertGL();
        GlStateManager.func_179121_F();
    }

    private void renderRing(EntityRing entity, float partialTicks) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buf = t.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        float size = entity.size * entity.interpolate(partialTicks);
        float opacity = entity.opacity * (1.0f - size / entity.size);
        float r = entity.r;
        float g = entity.g;
        float b = entity.b;
        buf.func_181662_b((double)(-size), (double)(-size), 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181666_a(r, g, b, opacity).func_181675_d();
        buf.func_181662_b((double)(-size), (double)size, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181666_a(r, g, b, opacity).func_181675_d();
        buf.func_181662_b((double)size, (double)size, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181666_a(r, g, b, opacity).func_181675_d();
        buf.func_181662_b((double)size, (double)(-size), 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181666_a(r, g, b, opacity).func_181675_d();
        t.func_78381_a();
    }

    private void setupGL() {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private void revertGL() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }
}

