/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.creativetab.CreativeTabHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntityEggInfo;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemSpawnEgg
extends Item {
    public ItemSpawnEgg() {
        this.func_77655_b("monsterPlacer");
        this.setRegistryName("spawn_egg");
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabHandler.INSTANCE.creativeTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            Iterator<MowzieEntityEggInfo> iterator = EntityHandler.INSTANCE.getEntityEggInfoIterator();
            while (iterator.hasNext()) {
                MowzieEntityEggInfo info = iterator.next();
                ItemStack stack = new ItemStack((Item)this);
                ItemSpawnEgg.applyEntityIdToItemStack(stack, info.id);
                subItems.add((Object)stack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = I18n.func_74838_a((String)(this.func_77658_a() + ".name")).trim();
        ResourceLocation entityName = ItemSpawnEgg.getEntityIdFromItem(stack);
        if (entityName != null) {
            name = name + " " + I18n.func_74838_a((String)("entity." + entityName.func_110623_a() + ".name"));
        }
        return name;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        TileEntity blockEntity;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150474_ac && (blockEntity = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic spawner = ((TileEntityMobSpawner)blockEntity).func_145881_a();
            spawner.func_190894_a(ItemSpawnEgg.getEntityIdFromItem(stack));
            blockEntity.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 3);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && state.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = ItemSpawnEgg.spawnCreature(worldIn, ItemSpawnEgg.getEntityIdFromItem(stack), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            ItemSpawnEgg.applyItemEntityDataToEntity(worldIn, playerIn, stack, entity);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemStackIn)) {
                Entity entity = ItemSpawnEgg.spawnCreature(worldIn, ItemSpawnEgg.getEntityIdFromItem(itemStackIn), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
                }
                if (entity instanceof EntityLivingBase && itemStackIn.func_82837_s()) {
                    entity.func_96094_a(itemStackIn.func_82833_r());
                }
                ItemSpawnEgg.applyItemEntityDataToEntity(worldIn, playerIn, itemStackIn, entity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemStackIn.func_190918_g(1);
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound compound;
        MinecraftServer server = entityWorld.func_73046_m();
        if (server != null && targetEntity != null && (compound = stack.func_77978_p()) != null && compound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && server.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(compound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    @Nullable
    public static Entity spawnCreature(World world, @Nullable ResourceLocation name, double x, double y, double z) {
        if (EntityHandler.INSTANCE.hasEntityEggInfo(name)) {
            EntityLiving entity = EntityHandler.INSTANCE.createEntity(name, world);
            if (entity instanceof EntityLivingBase) {
                EntityLiving entityLiving = entity;
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityLiving.field_70759_as = entityLiving.field_70177_z;
                entityLiving.field_70761_aq = entityLiving.field_70177_z;
                entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), null);
                world.func_72838_d((Entity)entity);
                entityLiving.func_70642_aH();
            }
            return entity;
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getEntityIdFromItem(ItemStack stack) {
        ResourceLocation res;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_150297_b("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = compound.func_74775_l("EntityTag");
        String id = nbttagcompound1.func_74779_i("id");
        return StringUtils.equals((CharSequence)id, (CharSequence)(res = new ResourceLocation(id)).toString()) ? res : null;
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation id) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound entityCompound = new NBTTagCompound();
        entityCompound.func_74778_a("id", id.toString());
        compound.func_74782_a("EntityTag", (NBTBase)entityCompound);
        stack.func_77982_d(compound);
    }
}

