/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.data.KnowledgeFragmentData;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.gui.GuiTelescope;
import hellfirepvp.astralsorcery.client.gui.base.GuiSkyScreen;
import hellfirepvp.astralsorcery.client.gui.base.GuiTileBase;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.ClientConstellationGenerator;
import hellfirepvp.astralsorcery.client.util.ClientUtils;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemKnowledgeFragment;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktDiscoverConstellation;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiObservatory
extends GuiTileBase<TileObservatory>
implements GuiSkyScreen {
    private static final Random random = new Random();
    private static final int frameSize = 16;
    private static final AbstractRenderableTexture texPartFrame = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "observatoryframe");
    private static final AbstractRenderableTexture textureConnection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
    private static final int randomStars = 220;
    private List<StarPosition> usedStars = new ArrayList<StarPosition>(220);
    private EntityPlayer owningPlayer;
    private Map<IConstellation, Map<StarLocation, Rectangle>> drawnStars = null;
    private boolean grabCursor = false;
    private LinkedList<GuiTelescope.Line> drawnLines = new LinkedList();
    private Point start;
    private Point end;

    public GuiObservatory(EntityPlayer owningPlayer, TileObservatory te) {
        super(te, new ScaledResolution(Minecraft.func_71410_x()).func_78328_b() - 32, new ScaledResolution(Minecraft.func_71410_x()).func_78326_a() - 32);
        this.owningPlayer = owningPlayer;
        Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
        currSeed.ifPresent(this::setupInitialStars);
    }

    private void setupInitialStars(long seed) {
        int i;
        Random rand = new Random(seed);
        int day = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / (long)Config.dayLength);
        for (i = 0; i < Math.abs(day); ++i) {
            rand.nextLong();
        }
        for (i = 0; i < 220; ++i) {
            this.usedStars.add(new StarPosition(16.0f + rand.nextFloat() * (float)this.guiWidth, 16.0f + rand.nextFloat() * (float)this.guiHeight));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new CPacketCloseWindow(this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c));
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_146297_k.field_71439_g.field_71069_bz;
        this.field_146297_k.field_71439_g.field_71069_bz.field_75152_c = 0;
        if (!Minecraft.field_142025_a) {
            KeyBinding.func_186704_a();
        }
        ClientUtils.grabMouseCursor();
        this.field_146297_k.field_71415_G = true;
        this.field_146297_k.field_71439_g.field_70761_aq = this.field_146297_k.field_71439_g.field_70759_as;
        this.field_146297_k.field_71439_g.field_70760_ar = this.field_146297_k.field_71439_g.field_70758_at;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_70125_A = ((TileObservatory)((Object)this.getOwningTileEntity())).observatoryPitch;
        this.field_146297_k.field_71439_g.field_70127_C = ((TileObservatory)((Object)this.getOwningTileEntity())).prevObservatoryPitch;
        this.field_146297_k.field_71439_g.field_70177_z = ((TileObservatory)((Object)this.getOwningTileEntity())).observatoryYaw;
        this.field_146297_k.field_71439_g.field_70759_as = ((TileObservatory)((Object)this.getOwningTileEntity())).observatoryYaw;
        this.field_146297_k.field_71439_g.field_70126_B = this.field_146297_k.field_71439_g.field_70177_z;
        this.field_146297_k.field_71439_g.field_70758_at = this.field_146297_k.field_71439_g.field_70177_z;
        if (!Minecraft.field_142025_a) {
            KeyBinding.func_186704_a();
        }
        ClientUtils.grabMouseCursor();
        this.field_146297_k.field_71415_G = true;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        this.drawnStars = null;
        this.handleMouseMovement(partialTicks);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        float pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        float transparency = 0.0f;
        if (pitch < 0.0f) {
            transparency = 1.0f;
        } else if (pitch < 10.0f) {
            transparency = (Math.abs(pitch) + 10.0f) / 10.0f;
            if (ConstellationSkyHandler.getInstance().isNight((World)w)) {
                transparency *= transparency;
            }
        }
        boolean canSeeSky = this.canTelescopeSeeSky((World)w);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(14 * sr.func_78325_e()), (int)(14 * sr.func_78325_e()), (int)((this.guiWidth + 2) * sr.func_78325_e()), (int)((this.guiHeight + 2) * sr.func_78325_e()));
        this.drawGridBackground(partialTicks, canSeeSky, transparency);
        this.drawEffectBackground(partialTicks, canSeeSky, transparency);
        GL11.glDisable((int)3089);
        this.field_73735_i += 10.0f;
        this.drawFrame();
        this.field_73735_i -= 10.0f;
    }

    private void drawEffectBackground(float partialTicks, boolean canSeeSky, float transparency) {
        if (this.usedStars.isEmpty()) {
            Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
            if (currSeed.isPresent()) {
                this.setupInitialStars(currSeed.get());
                this.field_73735_i += 5.0f;
                this.drawCellWithEffects(partialTicks, canSeeSky, transparency);
                this.field_73735_i -= 5.0f;
            }
        } else {
            this.field_73735_i += 5.0f;
            this.drawCellWithEffects(partialTicks, canSeeSky, transparency);
            this.field_73735_i -= 5.0f;
        }
    }

    private void drawCellWithEffects(float partialTicks, boolean canSeeSky, float transparency) {
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        Optional<Long> seed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
        long s = 0L;
        if (seed.isPresent()) {
            s = seed.get();
        }
        Random r = new Random(s * 31L + (long)(lastTracked * 31));
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.applyStateManager();
        if (canSeeSky) {
            int offsetX = this.guiLeft;
            int offsetZ = this.guiTop;
            this.field_73735_i += 1.0f;
            this.drawnStars = this.drawCellEffect(offsetX, offsetZ, this.getGuiWidth(), this.getGuiHeight(), partialTicks, transparency);
            this.field_73735_i -= 1.0f;
        } else {
            this.clearLines();
            this.abortDrawing();
        }
        this.field_73735_i += 2.0f;
        this.drawDrawnLines(r, partialTicks);
        this.field_73735_i -= 2.0f;
        GlStateManager.func_179084_k();
    }

    private void drawDrawnLines(final Random r, final float pTicks) {
        if (!this.canStartDrawing()) {
            this.clearLines();
            this.abortDrawing();
            return;
        }
        float linebreadth = 2.0f;
        RenderConstellation.BrightnessFunction func = new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + r.nextInt(15));
            }
        };
        textureConnection.bindTexture();
        for (int j = 0; j < 2; ++j) {
            for (GuiTelescope.Line l : this.drawnLines) {
                this.drawLine(l.start, l.end, func, linebreadth, true);
            }
            if (this.start == null || this.end == null) continue;
            Point adjStart = new Point(this.start.x - this.guiLeft, this.start.y - this.guiTop);
            Point adjEnd = new Point(this.end.x - this.guiLeft, this.end.y - this.guiTop);
            this.drawLine(adjStart, adjEnd, func, linebreadth, false);
        }
    }

    private void drawLine(Point start, Point end, RenderConstellation.BrightnessFunction func, float linebreadth, boolean applyFunc) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        float brightness = applyFunc ? func.getBrightness() : 1.0f;
        float starBr = Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f);
        if (starBr <= 0.0f) {
            return;
        }
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)(brightness < 0.0f ? 0.0f : (brightness *= starBr * 2.0f)));
        Vector3 fromStar = new Vector3((double)this.guiLeft + start.getX(), (double)this.guiTop + start.getY(), (double)this.field_73735_i);
        Vector3 toStar = new Vector3((double)this.guiLeft + end.getX(), (double)this.guiTop + end.getY(), (double)this.field_73735_i);
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
        }
        tes.func_78381_a();
    }

    private Map<IConstellation, Map<StarLocation, Rectangle>> drawCellEffect(int offsetX, int offsetY, int width, int height, final float partialTicks, final float transparency) {
        GlStateManager.func_179118_c();
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        final Random r = new Random();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarPosition stars : this.usedStars) {
            r.setSeed(stars.seed);
            GlStateManager.func_179094_E();
            float brightness = 0.3f + RenderConstellation.stdFlicker(ClientScheduler.getClientTick(), partialTicks, 5 + r.nextInt(15)) * 0.6f;
            brightness *= Minecraft.func_71410_x().field_71441_e.func_72880_h(partialTicks) * 2.0f * transparency;
            GlStateManager.func_179131_c((float)(brightness *= 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks)), (float)brightness, (float)brightness, (float)brightness);
            int size = r.nextInt(4) + 2;
            this.drawRect(MathHelper.func_76141_d((float)((float)offsetX + stars.x)), MathHelper.func_76141_d((float)((float)offsetY + stars.y)), size, size);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        Random cstRand = new Random(lastTracked * 31);
        for (int i = 0; i < 5 + cstRand.nextInt(10); ++i) {
            cstRand.nextLong();
        }
        r.setSeed(lastTracked * 31);
        double playerYaw = (Minecraft.func_71410_x().field_71439_g.field_70177_z + 180.0f) % 360.0f;
        double playerPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        if (playerYaw < 0.0) {
            playerYaw += 360.0;
        }
        if (playerYaw >= 180.0) {
            playerYaw -= 360.0;
        }
        float cstSizeX = 55.0f;
        float cstSizeY = 35.0f;
        final float rainBr = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks);
        HashMap<IConstellation, Map<StarLocation, Rectangle>> cstMap = new HashMap<IConstellation, Map<StarLocation, Rectangle>>();
        if (handle != null && transparency > 0.0f) {
            List<IConstellation> actives = handle.getActiveConstellations();
            LinkedList<IConstellation> scrollActives = new LinkedList<IConstellation>();
            List<ItemStack> fragmentStacks = ItemKnowledgeFragment.gatherFragments(this.owningPlayer);
            LinkedList<KnowledgeFragment> fragList = new LinkedList<KnowledgeFragment>();
            for (ItemStack item : fragmentStacks) {
                KnowledgeFragment frag = ItemKnowledgeFragment.resolveFragment(item);
                Optional<Long> seedOpt = ItemKnowledgeFragment.getSeed(item);
                if (!seedOpt.isPresent() || frag == null || fragList.contains(frag)) continue;
                fragList.add(frag);
                IConstellation cst = frag.getDiscoverConstellation(seedOpt.get());
                List<MoonPhase> phases = frag.getShowupPhases(seedOpt.get());
                if (cst == null || !phases.contains((Object)handle.getCurrentMoonPhase())) continue;
                scrollActives.add(cst);
            }
            Map<IConstellation, Point2D.Double> cstOffsets = this.generateOffsets(actives, scrollActives, cstRand);
            for (Map.Entry<IConstellation, Point2D.Double> constellationOffset : cstOffsets.entrySet()) {
                double diffYaw = playerYaw - (double)((float)constellationOffset.getValue().x);
                double diffPitch = playerPitch - (double)((float)constellationOffset.getValue().y);
                if (!(Math.abs(diffYaw) <= (double)cstSizeX)) {
                    double d;
                    diffYaw += 360.0;
                    if (!(Math.abs(d) <= (double)cstSizeX)) continue;
                }
                if (!(Math.abs(diffPitch) <= (double)cstSizeY)) continue;
                int wPart = (int)((float)width * 0.1f);
                int hPart = (int)((float)height * 0.1f);
                Map<StarLocation, Rectangle> rectangles = RenderConstellation.renderConstellationIntoGUI(constellationOffset.getKey(), offsetX + wPart + MathHelper.func_76128_c((double)(diffYaw / (double)cstSizeX * (double)width)), offsetY + hPart + MathHelper.func_76128_c((double)(diffPitch / (double)cstSizeY * (double)height)), this.field_73735_i, (int)((float)height * 0.6f), (int)((float)height * 0.6f), 2.0, new RenderConstellation.BrightnessFunction(){

                    @Override
                    public float getBrightness() {
                        return (0.4f + 0.6f * RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), partialTicks, 5 + r.nextInt(15))) * transparency * rainBr;
                    }
                }, ResearchManager.clientProgress.hasConstellationDiscovered(constellationOffset.getKey().getUnlocalizedName()), true);
                cstMap.put(constellationOffset.getKey(), rectangles);
            }
        }
        GlStateManager.func_179141_d();
        return cstMap;
    }

    private Map<IConstellation, Point2D.Double> generateOffsets(List<IConstellation> actives, List<IConstellation> knowledgeActives, Random r) {
        float cstGap = 10.0f;
        r.nextLong();
        HashMap<IConstellation, Point2D.Double> offsets = new HashMap<IConstellation, Point2D.Double>();
        for (IConstellation cst : actives) {
            float pitch;
            float yaw;
            Point2D.Double at;
            do {
                pitch = -6.5f + r.nextFloat() * -80.0f;
            } while (this.cstCollides(offsets, at = new Point2D.Double(yaw = r.nextFloat() * 360.0f, pitch), cstGap));
            offsets.put(cst, at);
        }
        for (IConstellation cst : knowledgeActives) {
            Point2D.Double found = null;
            for (int attempts = 50; attempts > 0; --attempts) {
                float pitch = -6.5f + r.nextFloat() * -80.0f;
                float yaw = r.nextFloat() * 360.0f;
                Point2D.Double at = new Point2D.Double(yaw, pitch);
                if (this.cstCollides(offsets, at, cstGap)) continue;
                found = at;
                break;
            }
            if (found == null) continue;
            offsets.put(cst, found);
        }
        return offsets;
    }

    private boolean cstCollides(Map<IConstellation, Point2D.Double> offsets, Point2D.Double at, float cstGap) {
        double sq = Math.sqrt(cstGap * cstGap * 2.0f);
        for (Point2D.Double point : offsets.values()) {
            if (!(point.distance(at) <= sq)) continue;
            return true;
        }
        return false;
    }

    private void drawFrame() {
        texPartFrame.bindTexture();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        this.drawTexturedRectAtCurrentPos(16.0, 16.0, 0.0f, 0.0f, 0.4f, 0.4f);
        GlStateManager.func_179109_b((float)(this.guiWidth + 16), (float)0.0f, (float)0.0f);
        this.drawTexturedRectAtCurrentPos(16.0, 16.0, 0.4f, 0.0f, 0.4f, 0.4f);
        GlStateManager.func_179109_b((float)0.0f, (float)(this.guiHeight + 16), (float)0.0f);
        this.drawTexturedRectAtCurrentPos(16.0, 16.0, 0.4f, 0.4f, 0.4f, 0.4f);
        GlStateManager.func_179109_b((float)(-(this.guiWidth + 16)), (float)0.0f, (float)0.0f);
        this.drawTexturedRectAtCurrentPos(16.0, 16.0, 0.0f, 0.4f, 0.4f, 0.4f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)16.0f, (float)0.0f, (float)0.0f);
        this.drawTexturedRectAtCurrentPos(this.guiWidth, 16.0, 0.8f, 0.0f, 0.05f, 0.4f);
        GlStateManager.func_179109_b((float)this.guiWidth, (float)16.0f, (float)0.0f);
        this.drawTexturedRectAtCurrentPos(16.0, this.guiHeight, 0.0f, 0.85f, 0.4f, 0.05f);
        GlStateManager.func_179109_b((float)(-this.guiWidth), (float)this.guiHeight, (float)0.0f);
        this.drawTexturedRectAtCurrentPos(this.guiWidth, 16.0, 0.85f, 0.0f, 0.05f, 0.4f);
        GlStateManager.func_179109_b((float)-16.0f, (float)(-this.guiHeight), (float)0.0f);
        this.drawTexturedRectAtCurrentPos(16.0, this.guiHeight, 0.0f, 0.8f, 0.4f, 0.05f);
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
    }

    private void handleMouseMovement(float pticks) {
        boolean ctrl = GuiObservatory.func_146272_n();
        if (this.grabCursor && !ctrl) {
            if (!Minecraft.field_142025_a) {
                KeyBinding.func_186704_a();
            }
            ClientUtils.grabMouseCursor();
            Minecraft.func_71410_x().field_71415_G = true;
            this.grabCursor = false;
            this.clearLines();
        }
        if (!this.grabCursor && ctrl) {
            ClientUtils.ungrabMouseCursor();
            Minecraft.func_71410_x().field_71415_G = false;
            this.grabCursor = true;
        }
        if (!ctrl) {
            float movementY;
            float movementX;
            float f = this.field_146297_k.field_71474_y.field_74341_c * 0.6f + 0.2f;
            float f1 = f * f * f * 8.0f;
            float f2 = (float)this.field_146297_k.field_71417_B.field_74377_a * f1;
            float f3 = (float)this.field_146297_k.field_71417_B.field_74375_b * f1;
            int i = 1;
            if (this.field_146297_k.field_71474_y.field_74338_d) {
                i = -1;
            }
            EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
            if (this.field_146297_k.field_71474_y.field_74326_T) {
                er.field_78496_H += f2;
                er.field_78497_I += f3;
                float f4 = pticks - er.field_78492_L;
                er.field_78492_L = pticks;
                f2 = er.field_78498_J * f4;
                f3 = er.field_78499_K * f4;
                movementX = f2;
                movementY = f3 * (float)i;
            } else {
                er.field_78496_H = 0.0f;
                er.field_78497_I = 0.0f;
                movementX = f2;
                movementY = f3 * (float)i;
            }
            boolean nullify = this.field_146297_k.field_71439_g.field_70125_A <= -89.99f && Math.abs(movementY) == movementY;
            this.field_146297_k.field_71439_g.func_70082_c(movementX, movementY);
            if (this.field_146297_k.field_71439_g.field_70125_A >= -10.0f) {
                this.field_146297_k.field_71439_g.field_70125_A = -10.0f;
                nullify = true;
            } else if (this.field_146297_k.field_71439_g.field_70125_A <= -75.0f) {
                this.field_146297_k.field_71439_g.field_70125_A = -75.0f;
                nullify = true;
            }
            if (nullify) {
                movementY = 0.0f;
            }
            this.moveIdleStars(MathHelper.func_76141_d((float)movementX), MathHelper.func_76141_d((float)movementY));
        }
    }

    private void moveIdleStars(int changeX, int changeY) {
        int width = this.guiWidth;
        int height = this.guiHeight;
        Iterator<StarPosition> iterator = this.usedStars.iterator();
        while (iterator.hasNext()) {
            StarPosition sl;
            StarPosition starPosition = sl = iterator.next();
            starPosition.x = starPosition.x - (float)changeX;
            starPosition = sl;
            starPosition.y = starPosition.y + (float)changeY;
            if (Math.abs(changeX) > 0) {
                if (sl.x < 0.0f) {
                    starPosition = sl;
                    starPosition.x = starPosition.x + (float)width;
                } else if (sl.x > (float)width) {
                    starPosition = sl;
                    starPosition.x = starPosition.x - (float)width;
                }
            }
            if (Math.abs(changeY) <= 0) continue;
            if (sl.y < 0.0f) {
                starPosition = sl;
                starPosition.y = starPosition.y + (float)height;
                continue;
            }
            if (!(sl.y > (float)height)) continue;
            starPosition = sl;
            starPosition.y = starPosition.y - (float)height;
        }
    }

    private void drawGridBackground(float partialTicks, boolean canSeeSky, float angleTransparency) {
        Blending.PREALPHA.applyStateManager();
        Tuple<Color, Color> fromTo = GuiSkyScreen.getRBGFromTo(canSeeSky, angleTransparency, partialTicks);
        RenderingUtils.drawGradientRect(this.guiLeft, this.guiTop, this.field_73735_i, this.guiLeft + this.guiWidth, this.guiTop + this.guiHeight, (Color)fromTo.key, (Color)fromTo.value);
        Blending.DEFAULT.applyStateManager();
    }

    private boolean canTelescopeSeeSky(World renderWorld) {
        BlockPos pos = ((TileObservatory)((Object)this.getOwningTileEntity())).func_174877_v();
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                BlockPos other;
                if (xx == 0 && zz == 0 || MiscUtils.canSeeSky(renderWorld, other = pos.func_177982_a(xx, 0, zz), true, false)) continue;
                return false;
            }
        }
        return MiscUtils.canSeeSky(renderWorld, pos.func_177984_a(), true, false);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            this.tryStartDrawing(mouseX, mouseY);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (clickedMouseButton == 0) {
            this.informMovement(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.informRelease(mouseX, mouseY);
        }
    }

    private void tryStartDrawing(int mouseX, int mouseY) {
        if (!this.canStartDrawing()) {
            return;
        }
        this.start = new Point(mouseX, mouseY);
        this.end = new Point(mouseX, mouseY);
    }

    private boolean canStartDrawing() {
        return Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f) >= 0.35f && Minecraft.func_71410_x().field_71441_e.func_72867_j(1.0f) <= 0.1f;
    }

    private void clearLines() {
        this.drawnLines.clear();
    }

    private void informMovement(int mouseX, int mouseY) {
        this.end = new Point(mouseX, mouseY);
    }

    private void informRelease(int mouseX, int mouseY) {
        if (this.start != null) {
            this.end = new Point(mouseX, mouseY);
            this.pushDrawnLine(this.start, this.end);
        } else {
            this.start = null;
            this.end = null;
        }
        this.abortDrawing();
        this.checkConstellation(this.drawnLines);
    }

    private void checkConstellation(List<GuiTelescope.Line> drawnLines) {
        block0: for (Map.Entry<IConstellation, Map<StarLocation, Rectangle>> info : this.drawnStars.entrySet()) {
            List<StarConnection> sc;
            IConstellation c = info.getKey();
            if (c == null || ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) continue;
            PlayerProgress client = ResearchManager.clientProgress;
            if (client == null) {
                return;
            }
            boolean has = c instanceof ClientConstellationGenerator.ClientConstellation;
            for (String strConstellation : client.getSeenConstellations()) {
                IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
                if (ce == null || !ce.equals(c)) continue;
                has = true;
                break;
            }
            if (!has || (sc = c.getStarConnections()).size() != drawnLines.size() || !c.canDiscover((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ResearchManager.clientProgress)) continue;
            Map<StarLocation, Rectangle> stars = info.getValue();
            for (StarConnection connection : sc) {
                Rectangle fromRect = stars.get(connection.from);
                if (fromRect == null) {
                    AstralSorcery.log.info("Could not check constellation of telescope drawing - starLocation is missing?");
                    continue block0;
                }
                Rectangle toRect = stars.get(connection.to);
                if (toRect == null) {
                    AstralSorcery.log.info("Could not check constellation of telescope drawing - starLocation is missing?");
                    continue block0;
                }
                if (this.containsMatch(drawnLines, fromRect, toRect)) continue;
                continue block0;
            }
            if (c instanceof ClientConstellationGenerator.ClientConstellation) {
                KnowledgeFragment frag = ((ClientConstellationGenerator.ClientConstellation)c).getFragment();
                if (frag != null) {
                    ItemKnowledgeFragment.clearFragment(this.owningPlayer, frag);
                    KnowledgeFragmentData dat = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
                    if (dat.addFragment(frag)) {
                        String cName = c.getUnlocalizedName();
                        cName = cName.isEmpty() ? "" : Character.toUpperCase(cName.charAt(0)) + cName.substring(1);
                        this.owningPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_135052_a((String)"misc.fragment.added.cst", (Object[])new Object[]{cName})));
                        this.owningPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_135052_a((String)"misc.fragment.added", (Object[])new Object[]{frag.getLocalizedIndexName()})));
                    }
                }
            } else {
                PacketChannel.CHANNEL.sendToServer((IMessage)new PktDiscoverConstellation(c.getUnlocalizedName()));
            }
            this.clearLines();
            this.abortDrawing();
            return;
        }
    }

    private boolean containsMatch(List<GuiTelescope.Line> drawnLines, Rectangle r1, Rectangle r2) {
        for (GuiTelescope.Line l : drawnLines) {
            Point start = l.start;
            Point end = l.end;
            start = new Point(start.x + this.guiLeft, start.y + this.guiTop);
            end = new Point(end.x + this.guiLeft, end.y + this.guiTop);
            if ((!r1.contains(start) || !r2.contains(end)) && (!r2.contains(start) || !r1.contains(end))) continue;
            return true;
        }
        return false;
    }

    private void pushDrawnLine(Point start, Point end) {
        if (Math.abs(start.getX() - end.getX()) <= 2.0 && Math.abs(start.getY() - end.getY()) <= 2.0) {
            return;
        }
        Point adjStart = new Point(start.x - this.guiLeft, start.y - this.guiTop);
        Point adjEnd = new Point(end.x - this.guiLeft, end.y - this.guiTop);
        GuiTelescope.Line l = new GuiTelescope.Line(adjStart, adjEnd);
        this.drawnLines.addLast(l);
    }

    private void abortDrawing() {
        this.start = null;
        this.end = null;
    }

    static /* synthetic */ Random access$400() {
        return random;
    }

    private static class StarPosition {
        private float x;
        private float y;
        private long seed = GuiObservatory.access$400().nextLong();

        private StarPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

