/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.overlay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournalOverlay;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.VanillaAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReaderRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PlayerAttributeInterpreter;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class GuiJournalOverlayPerkStats
extends GuiScreenJournalOverlay {
    public static final BindableResource texturePerkStatOverlay = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guicontippaper_blank");
    private static final int HEADER_WIDTH = 190;
    private static final int DEFAULT_WIDTH = 175;
    private final List<PerkStatistic> statistics = new LinkedList<PerkStatistic>();
    private int nameStrWidth = -1;
    private int valueStrWidth = -1;
    private int suffixStrWidth = -1;

    public GuiJournalOverlayPerkStats(GuiScreenJournal origin) {
        super(origin);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statistics.clear();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerAttributeInterpreter interpreter = PlayerAttributeInterpreter.defaultInterpreter((EntityPlayer)player);
        AttributeTypeRegistry.getTypes().stream().filter(t -> t instanceof VanillaAttributeType).forEach(arg_0 -> GuiJournalOverlayPerkStats.lambda$initGui$1((EntityPlayer)player, arg_0));
        for (PerkAttributeType type : AttributeTypeRegistry.getTypes()) {
            PerkStatistic strPerkStat;
            if (!type.hasTypeApplied((EntityPlayer)player, Side.CLIENT) || (strPerkStat = interpreter.getValue(type)) == null) continue;
            this.statistics.add(strPerkStat);
        }
        this.statistics.sort(Comparator.comparing(perkStatistic -> I18n.func_135052_a((String)perkStatistic.getUnlocPerkTypeName(), (Object[])new Object[0])));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        int width = 275;
        int height = 344;
        GlStateManager.func_179097_i();
        texturePerkStatOverlay.bindTexture();
        this.drawTexturedRect((double)(this.guiLeft + this.guiWidth / 2 - width / 2), (double)(this.guiTop + this.guiHeight / 2 - height / 2), (double)width, (double)height, texturePerkStatOverlay);
        GlStateManager.func_179126_j();
        this.drawHeader();
        this.drawPageText(mouseX, mouseY);
        TextureHelper.refreshTextureBindState();
    }

    private void drawHeader() {
        String locTitle = I18n.func_135052_a((String)"perk.reader.gui", (Object[])new Object[0]);
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        List split = fr.func_78271_c(locTitle, MathHelper.func_76128_c((double)135.71428571428572));
        int step = 14;
        int offsetTop = this.guiTop + 15 - split.size() * step / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)offsetTop, (float)0.0f);
        for (int i = 0; i < split.size(); ++i) {
            String s = (String)split.get(i);
            double offsetLeft = (double)(this.field_146294_l / 2) - (double)fr.func_78256_a(s) * 1.4 / 2.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)offsetLeft, (double)(i * step), (double)0.0);
            GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
            GlStateManager.func_179097_i();
            fr.func_175065_a(s, 0.0f, 0.0f, -298634445, false);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawPageText(int mouseX, int mouseY) {
        if (this.nameStrWidth == -1 || this.valueStrWidth == -1 || this.suffixStrWidth == -1) {
            this.buildDisplayWidth();
        }
        HashMap valueStrMap = Maps.newHashMap();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetY = this.guiTop + 40;
        int offsetX = this.guiLeft + this.guiWidth / 2 - 87;
        int line = 0;
        for (PerkStatistic stat : this.statistics) {
            GlStateManager.func_179097_i();
            this.field_146289_q.func_175065_a(I18n.func_135052_a((String)stat.getUnlocPerkTypeName(), (Object[])new Object[0]), (float)offsetX, (float)(offsetY + line * 10), -298634445, false);
            this.field_146289_q.func_175065_a(stat.getPerkValue(), (float)(offsetX + this.nameStrWidth), (float)(offsetY + line * 10), -298634445, false);
            GlStateManager.func_179126_j();
            int strLength = this.field_146289_q.func_78256_a(stat.getPerkValue());
            Rectangle rctValue = new Rectangle(offsetX + this.nameStrWidth, offsetY + line * 10, strLength, 8);
            valueStrMap.put(rctValue, stat);
            if (!stat.getSuffix().isEmpty()) {
                GlStateManager.func_179097_i();
                this.field_146289_q.func_175065_a(stat.getSuffix(), (float)(offsetX + 25), (float)(offsetY + ++line * 10), -298634445, false);
                GlStateManager.func_179126_j();
            }
            ++line;
        }
        for (Rectangle rct : valueStrMap.keySet()) {
            if (!rct.contains(mouseX, mouseY)) continue;
            PerkStatistic stat = (PerkStatistic)valueStrMap.get(rct);
            this.drawCalculationDescription(rct.x + rct.width + 2, rct.y + 15, stat);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawCalculationDescription(int x, int y, PerkStatistic stat) {
        PerkAttributeType type = stat.getType();
        AttributeReader reader = AttributeReaderRegistry.getReader(type.getTypeString());
        if (reader == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerAttributeMap attrMap = PerkAttributeHelper.getOrCreateMap((EntityPlayer)player, Side.CLIENT);
        ArrayList information = Lists.newArrayList();
        information.add(I18n.func_135052_a((String)"perk.reader.description.head", (Object[])new Object[]{AttributeReader.formatDecimal(reader.getDefaultValue(attrMap, (EntityPlayer)player, Side.CLIENT))}));
        information.add(I18n.func_135052_a((String)"perk.reader.description.addition", (Object[])new Object[]{AttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (EntityPlayer)player, Side.CLIENT, PerkAttributeModifier.Mode.ADDITION) - 1.0)}));
        information.add(I18n.func_135052_a((String)"perk.reader.description.increase", (Object[])new Object[]{AttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (EntityPlayer)player, Side.CLIENT, PerkAttributeModifier.Mode.ADDED_MULTIPLY))}));
        information.add(I18n.func_135052_a((String)"perk.reader.description.moreless", (Object[])new Object[]{AttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (EntityPlayer)player, Side.CLIENT, PerkAttributeModifier.Mode.STACKING_MULTIPLY))}));
        if (!stat.getSuffix().isEmpty() || !stat.getPostProcessInfo().isEmpty()) {
            information.add("");
        }
        if (!stat.getSuffix().isEmpty()) {
            information.add(stat.getSuffix());
        }
        if (!stat.getPostProcessInfo().isEmpty()) {
            information.add(stat.getPostProcessInfo());
        }
        RenderingUtils.renderBlueTooltip(x, y, information, this.field_146289_q);
    }

    private void buildDisplayWidth() {
        this.nameStrWidth = -1;
        this.valueStrWidth = -1;
        this.suffixStrWidth = -1;
        for (PerkStatistic stat : this.statistics) {
            int nameWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)stat.getUnlocPerkTypeName(), (Object[])new Object[0]));
            int valueWidth = this.field_146289_q.func_78256_a(stat.getPerkValue());
            int suffixWidth = this.field_146289_q.func_78256_a(stat.getSuffix());
            if (nameWidth > this.nameStrWidth) {
                this.nameStrWidth = nameWidth;
            }
            if (valueWidth > this.valueStrWidth) {
                this.valueStrWidth = valueWidth;
            }
            if (suffixWidth <= this.suffixStrWidth) continue;
            this.suffixStrWidth = suffixWidth;
        }
        this.nameStrWidth += 6;
        this.valueStrWidth += 6;
        this.suffixStrWidth += 6;
    }

    private static /* synthetic */ void lambda$initGui$1(EntityPlayer player, PerkAttributeType t) {
        ((VanillaAttributeType)t).refreshAttribute(player);
    }
}

