/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.registry.RegistryBookLookups;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class JournalPageRecipe
implements IJournalPage {
    public AccessibleRecipeAdapater recipe;

    public JournalPageRecipe(AccessibleRecipeAdapater recipe) {
        this.recipe = recipe;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.recipe);
    }

    public static class Render
    implements IGuiRenderablePage {
        private static final BindableResource texGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "griddisc");
        private final AccessibleRecipeAdapater recipe;
        private Map<Rectangle, ItemStack> thisFrameStackFrames = new HashMap<Rectangle, ItemStack>();

        public Render(AccessibleRecipeAdapater recipe) {
            this.recipe = recipe;
        }

        @Override
        public boolean propagateMouseClick(int mouseX, int mouseZ) {
            for (Rectangle r : this.thisFrameStackFrames.keySet()) {
                ItemStack stack;
                RegistryBookLookups.LookupInfo lookup;
                if (!r.contains(mouseX, mouseZ) || (lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack = this.thisFrameStackFrames.get(r))) == null) continue;
                RegistryBookLookups.openLookupJournalPage(lookup);
            }
            return false;
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            this.thisFrameStackFrames.clear();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            Blending.DEFAULT.apply();
            texGrid.bind();
            this.drawRect(offsetX + 25.0f, offsetY, 129.0, 202.0, zLevel);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            RenderHelper.func_74520_c();
            ItemStack out = this.recipe.func_77571_b();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetX + 78.0f), (double)(offsetY + 25.0f), (double)(zLevel + 60.0f));
            GL11.glScaled((double)1.4, (double)1.4, (double)1.4);
            Rectangle r = this.drawItemStack(out, 0, 0, 0.0f);
            r = new Rectangle((int)offsetX + 78, (int)offsetY + 25, (int)(r.getWidth() * 1.4), (int)(r.getHeight() * 1.4));
            this.thisFrameStackFrames.put(r, out);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
            double offX = offsetX + 55.0f;
            double offY = offsetY + 103.0f;
            for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
                NonNullList<ItemStack> expected = this.recipe.getExpectedStackForRender(srs);
                if (expected == null || expected.isEmpty()) {
                    expected = this.recipe.getExpectedStackForRender(srs.rowMultipler, srs.columnMultiplier);
                }
                if (expected == null || expected.isEmpty()) continue;
                long select = (ClientScheduler.getClientTick() + (long)(srs.rowMultipler * 40) + (long)(srs.columnMultiplier * 40)) / 20L;
                ItemStack draw = (ItemStack)expected.get((int)(select %= (long)expected.size()));
                GL11.glPushMatrix();
                GL11.glTranslated((double)(offX + (double)(srs.columnMultiplier * 25)), (double)(offY + (double)(srs.rowMultipler * 25)), (double)(zLevel + 60.0f));
                GL11.glScaled((double)1.13, (double)1.13, (double)1.13);
                RenderHelper.func_74520_c();
                r = this.drawItemStack(draw, 0, 0, 0.0f);
                r = new Rectangle((int)offX + srs.columnMultiplier * 25, (int)offY + srs.rowMultipler * 25, (int)(r.getWidth() * 1.4), (int)(r.getHeight() * 1.4));
                this.thisFrameStackFrames.put(r, draw);
                GL11.glPopMatrix();
                TextureHelper.refreshTextureBindState();
            }
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            RenderHelper.func_74518_a();
            GL11.glPopAttrib();
        }

        public void addStackTooltip(float mouseX, float mouseY, List<String> tooltip) {
            for (Rectangle rect : this.thisFrameStackFrames.keySet()) {
                RegistryBookLookups.LookupInfo lookup;
                if (!rect.contains(mouseX, mouseY)) continue;
                ItemStack stack = this.thisFrameStackFrames.get(rect);
                try {
                    tooltip.addAll(stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
                }
                catch (Throwable tr) {
                    tooltip.add(TextFormatting.RED + "<Error upon trying to get this item's tooltip>");
                }
                if ((lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack)) == null) continue;
                tooltip.add("");
                tooltip.add(I18n.func_135052_a((String)"misc.craftInformation", (Object[])new Object[0]));
            }
        }

        @Override
        public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            LinkedList out = Lists.newLinkedList();
            this.addStackTooltip(mouseX, mouseY, out);
            if (!out.isEmpty()) {
                RenderingUtils.renderBlueTooltip((int)mouseX, (int)mouseY, out, this.getStandardFontRenderer());
            }
            GL11.glDisable((int)3042);
            GL11.glPopAttrib();
        }
    }
}

