/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.perk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.gui.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PerkRenderGroup {
    private static int counter = 0;
    private final int id;
    private List<BatchPerkContext.TextureObjectGroup> addedGroups = Lists.newArrayList();
    private Map<AbstractRenderableTexture, Integer> underlyingTextures = Maps.newHashMap();

    public PerkRenderGroup() {
        this.id = counter++;
    }

    public void add(AbstractRenderableTexture texture, Integer priority) {
        this.underlyingTextures.put(texture, priority);
    }

    public void batchRegister(BatchPerkContext ctx) {
        for (AbstractRenderableTexture tex : this.underlyingTextures.keySet()) {
            this.addedGroups.add(ctx.addContext(tex, this.underlyingTextures.get(tex)));
        }
    }

    @Nullable
    public BatchPerkContext.TextureObjectGroup getGroup(AbstractRenderableTexture texture) {
        return MiscUtils.iterativeSearch(this.addedGroups, grp -> grp.getResource().equals(texture));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkRenderGroup that = (PerkRenderGroup)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

