/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.camera;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraManager;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class ClientCameraFlightHelper {
    public static CameraFlightBuilder builder(Vector3 start, Vector3 cameraFocus) {
        return new CameraFlightBuilder(start, cameraFocus);
    }

    public static interface DynamicRadiusGetter {
        public double getRadius(double var1);

        public static DynamicRadiusGetter dyanmicIncrease(final double base, final double incPerStep) {
            return new DynamicRadiusGetter(){
                private double baseDst;
                private int count;
                {
                    this.baseDst = base;
                    this.count = 0;
                }

                @Override
                public double getRadius(double degree) {
                    double rad = this.baseDst + (double)this.count * incPerStep;
                    ++this.count;
                    return rad;
                }
            };
        }
    }

    public static class CameraFlight
    extends ClientCameraManager.EntityRenderViewReplacement
    implements ClientCameraManager.PersistencyFunction {
        private LinkedList<FlightPoint> flightPoints = new LinkedList();
        private final Vector3 startVector;
        private final Vector3 focus;
        private TickDelegate delegate;
        private StopDelegate stopDelegate;
        private int totalTickDuration = 0;
        private boolean expired = false;
        private boolean stopped = false;

        private CameraFlight(Vector3 startPoint, Vector3 focusPoint, @Nullable TickDelegate tick) {
            this.startVector = startPoint;
            this.focus = focusPoint;
            this.field_70165_t = startPoint.getX();
            this.field_70163_u = startPoint.getY();
            this.field_70161_v = startPoint.getZ();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.delegate = tick;
            this.setCameraFocus(focusPoint);
            this.transformToFocusOnPoint(focusPoint, 0.0f, false);
        }

        public void setTickDelegate(TickDelegate delegate) {
            this.delegate = delegate;
        }

        private void addPoint(Vector3 point, int ticks) {
            this.flightPoints.addLast(new FlightPoint(point, ticks));
            this.totalTickDuration += ticks;
        }

        @Override
        public void moveEntityTick(ClientCameraManager.EntityRenderViewReplacement entity, ClientCameraManager.EntityClientReplacement replacement, int ticksExisted) {
            if (this.delegate != null) {
                this.delegate.tick(entity, replacement);
            }
            this.setCameraFocus(Vector3.atEntityCenter((Entity)replacement));
            boolean bl = this.expired = this.field_70173_aa > this.totalTickDuration;
            if (this.flightPoints.isEmpty()) {
                this.expired = true;
            } else {
                Vector3 position = this.queryByTicks(ticksExisted);
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                this.field_70165_t = position.getX();
                this.field_70163_u = position.getY();
                this.field_70161_v = position.getZ();
            }
        }

        @Override
        public void onStopTransforming() {
            if (this.stopDelegate != null && Minecraft.func_71410_x().field_71441_e != null) {
                this.stopDelegate.onCameraFlightStop();
            }
        }

        private Vector3 queryByTicks(int ticks) {
            if (ticks <= 0) {
                return this.startVector;
            }
            int acc = 0;
            FlightPoint current = null;
            for (FlightPoint point : this.flightPoints) {
                int accumulator = acc + point.ticksToGetThere;
                Vector3 prev = current == null ? this.startVector : current.dstPoint;
                current = point;
                if (accumulator >= ticks) {
                    int interp = current.ticksToGetThere - (accumulator - ticks);
                    int dstJump = current.ticksToGetThere;
                    return current.dstPoint.clone().subtract(prev).divide(dstJump).multiply(MathHelper.func_76125_a((int)interp, (int)1, (int)dstJump)).add(prev);
                }
                acc = accumulator;
            }
            return this.flightPoints.getLast().dstPoint;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void setExpired() {
            this.expired = true;
        }

        public void forceStop() {
            this.stopped = true;
            this.setExpired();
        }

        public boolean wasForciblyStopped() {
            return this.stopped;
        }

        @Override
        public boolean needsRemoval() {
            return this.expired;
        }

        private CameraFlight copy() {
            CameraFlight c = new CameraFlight(this.startVector, this.focus, this.delegate);
            for (FlightPoint fp : this.flightPoints) {
                c.flightPoints.addLast(new FlightPoint(fp.dstPoint, fp.ticksToGetThere));
            }
            c.totalTickDuration = this.totalTickDuration;
            return c;
        }

        public void setStopDelegate(StopDelegate delegate) {
            this.stopDelegate = delegate;
        }

        private static class FlightPoint {
            private final Vector3 dstPoint;
            private final int ticksToGetThere;

            private FlightPoint(Vector3 dstPoint, int ticksToGetThere) {
                this.dstPoint = dstPoint;
                this.ticksToGetThere = ticksToGetThere;
            }
        }
    }

    public static interface TickDelegate {
        public void tick(ClientCameraManager.EntityRenderViewReplacement var1, ClientCameraManager.EntityClientReplacement var2);
    }

    public static interface StopDelegate {
        public void onCameraFlightStop();
    }

    public static class CameraFlightBuilder {
        private final CameraFlight flight;

        private CameraFlightBuilder(Vector3 start, Vector3 cameraFocus) {
            this.flight = new CameraFlight(start, cameraFocus, null);
        }

        public CameraFlightBuilder(CameraFlight flight) {
            this.flight = flight;
        }

        public CameraFlightBuilder addPoint(Vector3 nextPoint, int ticksToFlyThere) {
            if (ticksToFlyThere < 0) {
                AstralSorcery.log.warn("Tried to add a point with negative tick-timespan to a camera flight. Skipping...");
                return this;
            }
            this.flight.addPoint(nextPoint, ticksToFlyThere);
            return this;
        }

        public CameraFlightBuilder addCircularPoints(Vector3 centerOffset, double radius, int amountOfPointsOnCircle, int ticksBetweenEachPoint) {
            return this.addCircularPoints(centerOffset, deg -> radius, amountOfPointsOnCircle, ticksBetweenEachPoint);
        }

        public CameraFlightBuilder addCircularPoints(Vector3 centerOffset, DynamicRadiusGetter radius, int amountOfPointsOnCircle, int ticksBetweenEachPoint) {
            if (ticksBetweenEachPoint < 0) {
                AstralSorcery.log.warn("Tried to add a point with negative tick-timespan to a camera flight. Skipping...");
                return this;
            }
            double degPerPoint = 360.0 / (double)amountOfPointsOnCircle;
            for (int i = 0; i < amountOfPointsOnCircle; ++i) {
                double deg = (double)i * degPerPoint;
                Vector3 point = Vector3.RotAxis.Y_AXIS.clone().perpendicular().normalize().multiply(radius.getRadius(deg)).rotate(Math.toRadians(deg), Vector3.RotAxis.Y_AXIS).add(centerOffset);
                this.addPoint(point, ticksBetweenEachPoint);
            }
            return this;
        }

        public CameraFlightBuilder copy() {
            return new CameraFlightBuilder(this.flight.copy());
        }

        public CameraFlightBuilder setTickDelegate(TickDelegate delegate) {
            this.flight.setTickDelegate(delegate);
            return this;
        }

        public CameraFlightBuilder setStopDelegate(StopDelegate delegate) {
            this.flight.setStopDelegate(delegate);
            return this;
        }

        public CameraFlight finishAndStart() {
            if (this.flight.flightPoints.size() <= 0) {
                AstralSorcery.log.warn("Tried to start a camera flight without any points! Skipping...");
                return null;
            }
            ClientCameraManager.CameraTransformerRenderReplacement repl = new ClientCameraManager.CameraTransformerRenderReplacement(this.flight, this.flight);
            ClientCameraManager.getInstance().addTransformer(repl);
            return this.flight;
        }
    }
}

