/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.flare;

import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PatreonPartialEntity {
    protected static final Random rand = new Random();
    private static int counter = 0;
    private final UUID ownerUUID;
    private UUID partialEntityUUID;
    private int id;
    protected Vector3 pos = new Vector3();
    protected Vector3 prevPos = new Vector3();
    protected Vector3 motion = new Vector3();
    protected boolean removed = false;
    protected boolean updatePos = false;
    private Integer lastTickedDim = null;

    public PatreonPartialEntity(UUID ownerUUID) {
        this.id = counter++;
        this.ownerUUID = ownerUUID;
        this.partialEntityUUID = UUID.randomUUID();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public int getId() {
        return this.id;
    }

    public void setPositionNear(EntityPlayer player) {
        this.pos = Vector3.atEntityCenter((Entity)player).setY(player.field_70163_u).addY(player.field_70131_O).add(Vector3.random().setY(0).normalize());
        this.prevPos = this.pos.clone();
        this.motion = new Vector3();
        this.updatePos = true;
    }

    public UUID getUniqueId() {
        return this.partialEntityUUID;
    }

    @Nullable
    public Integer getLastTickedDim() {
        return this.lastTickedDim;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean update(World world) {
        boolean changed = this.lastTickedDim == null || this.lastTickedDim.intValue() != world.field_73011_w.getDimension();
        this.lastTickedDim = world.field_73011_w.getDimension();
        if (this.trySetMoveTarget(world)) {
            changed = true;
        }
        if (this.tryMoveEntity(world)) {
            changed = true;
        }
        if (world.field_72995_K) {
            this.spawnEffects();
        }
        return changed;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnEffects() {
    }

    private boolean trySetMoveTarget(World world) {
        Vector3 prevMot = this.motion.clone();
        EntityPlayer target = this.findOwner(world);
        if (target == null) {
            this.motion = new Vector3();
        } else {
            Vector3 moveTarget = Vector3.atEntityCenter((Entity)target).addY(1.5);
            if (moveTarget.distanceSquared(this.pos) <= 3.0) {
                this.motion.multiply(0.95f);
            } else {
                double diffX = (moveTarget.getX() - this.pos.getX()) / 8.0;
                double diffY = (moveTarget.getY() - this.pos.getY()) / 8.0;
                double diffZ = (moveTarget.getZ() - this.pos.getZ()) / 8.0;
                double dist = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                this.motion = new Vector3(diffX * dist, diffY * dist, diffZ * dist);
            }
        }
        return !this.motion.equals(prevMot);
    }

    private boolean tryMoveEntity(World world) {
        this.prevPos = this.pos.clone();
        EntityPlayer owner = this.findOwner(world);
        if (owner != null && this.pos.distance(Vector3.atEntityCenter((Entity)owner)) >= 16.0) {
            this.setPositionNear(owner);
            return true;
        }
        this.pos.add(this.motion);
        return !this.pos.equals(this.prevPos);
    }

    public Vector3 getPos() {
        return this.pos.clone();
    }

    public Vector3 getPrevPos() {
        return this.prevPos.clone();
    }

    @Nullable
    public EntityPlayer findOwner(World world) {
        return world.func_152378_a(this.ownerUUID);
    }

    @SideOnly(value=Side.CLIENT)
    public void tickInRenderDistance() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PatreonPartialEntity)) {
            return false;
        }
        PatreonPartialEntity that = (PatreonPartialEntity)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void readFromNBT(NBTTagCompound cmp) {
        this.id = cmp.func_74762_e("flareID");
        this.lastTickedDim = cmp.func_74762_e("lastTickedDim");
        this.partialEntityUUID = cmp.func_186857_a("uniqueId");
        if (cmp.func_74764_b("pos") && cmp.func_74764_b("prevPos")) {
            this.pos = NBTHelper.readVector3(cmp.func_74775_l("pos"));
            this.prevPos = NBTHelper.readVector3(cmp.func_74775_l("prevPos"));
        }
    }

    public void writeToNBT(NBTTagCompound cmp) {
        cmp.func_74768_a("flareID", this.id);
        cmp.func_74768_a("lastTickedDim", this.lastTickedDim == null ? 0 : this.lastTickedDim);
        cmp.func_186854_a("uniqueId", this.partialEntityUUID);
        if (this.updatePos) {
            cmp.func_74782_a("pos", (NBTBase)NBTHelper.writeVector3(this.pos));
            cmp.func_74782_a("prevPos", (NBTBase)NBTHelper.writeVector3(this.prevPos));
            this.updatePos = false;
        }
    }
}

