/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CEffectPositionListGen<T extends CEffectGenListEntry>
extends ConstellationEffect {
    protected final Function<BlockPos, T> elementProvider;
    protected final int maxCount;
    protected final Verifier verifier;
    private List<T> elements = new ArrayList<T>();

    public CEffectPositionListGen(@Nullable ILocatable origin, IWeakConstellation constellation, String cfgName, int maxCount, Verifier verifier, Function<BlockPos, T> emptyElementProvider) {
        super(origin, constellation, cfgName);
        this.elementProvider = emptyElementProvider;
        this.maxCount = maxCount;
        this.verifier = verifier;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public void clearCache() {
        this.elements.clear();
    }

    @Nullable
    public T getRandomElement(Random rand) {
        return (T)(this.elements.isEmpty() ? null : (CEffectGenListEntry)this.elements.get(rand.nextInt(this.elements.size())));
    }

    @Nullable
    public T getRandomElementByChance(Random rand) {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (rand.nextInt(Math.max((this.maxCount - this.elements.size()) / 4, 0) + 1) == 0) {
            return this.getRandomElement(rand);
        }
        return null;
    }

    public boolean removeElement(T element) {
        return this.elements.remove(element);
    }

    public boolean offerNewElement(T element) {
        if (this.maxCount <= this.elements.size()) {
            return false;
        }
        if (this.containsElementAt(element.getPos())) {
            return false;
        }
        return this.elements.add(element);
    }

    public boolean findNewPosition(World world, BlockPos pos, ConstellationEffectProperties prop) {
        double offZ;
        double offY;
        double searchRange;
        double offX;
        BlockPos at;
        if (this.maxCount > this.elements.size() && MiscUtils.isChunkLoaded(world, at = pos.func_177963_a(offX = -(searchRange = prop.getSize()) + (double)world.field_73012_v.nextFloat() * (2.0 * searchRange + 1.0), offY = -searchRange + (double)world.field_73012_v.nextFloat() * (2.0 * searchRange + 1.0), offZ = -searchRange + (double)world.field_73012_v.nextFloat() * (2.0 * searchRange + 1.0))) && this.verifier.isValid(world, at) && !this.containsElementAt(at)) {
            T element = this.newElement(world, at);
            if (element != null) {
                this.elements.add(element);
            }
            return true;
        }
        return false;
    }

    public boolean findNewPositionAt(World world, BlockPos pos, BlockPos at, ConstellationEffectProperties prop) {
        if (this.maxCount > this.elements.size()) {
            double searchRange = prop.getSize();
            if ((double)Math.abs(pos.func_177958_n() - at.func_177958_n()) > searchRange || (double)Math.abs(pos.func_177956_o() - at.func_177956_o()) > searchRange || (double)Math.abs(pos.func_177952_p() - at.func_177952_p()) > searchRange) {
                return false;
            }
            if (MiscUtils.isChunkLoaded(world, at) && this.verifier.isValid(world, at) && !this.containsElementAt(at)) {
                T element = this.newElement(world, at);
                if (element != null) {
                    this.elements.add(element);
                }
                return true;
            }
        }
        return false;
    }

    public T newElement(World world, BlockPos at) {
        return (T)((CEffectGenListEntry)this.elementProvider.apply(at));
    }

    private boolean containsElementAt(BlockPos pos) {
        for (CEffectGenListEntry e : this.elements) {
            if (!e.getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        this.elements.clear();
        NBTTagList list = cmp.func_150295_c("positions", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(tag);
            CEffectGenListEntry element = (CEffectGenListEntry)this.elementProvider.apply(pos);
            if (element == null) continue;
            element.readFromNBT(tag);
            this.elements.add(element);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        NBTTagList listPositions = new NBTTagList();
        for (CEffectGenListEntry elem : this.elements) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(elem.getPos(), tag);
            elem.writeToNBT(tag);
            listPositions.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("positions", (NBTBase)listPositions);
    }

    public static interface CEffectGenListEntry {
        public BlockPos getPos();

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);
    }

    public static interface Verifier {
        public boolean isValid(World var1, BlockPos var2);
    }
}

