/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.reader.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeLimiter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AddedPercentageAttributeReader
extends AttributeReader {
    protected final PerkAttributeType attribute;
    protected float defaultValue;

    public AddedPercentageAttributeReader(PerkAttributeType attribute) {
        this.attribute = attribute;
        this.defaultValue = attribute.isMultiplicative() ? 1.0f : 0.0f;
    }

    public <T extends AddedPercentageAttributeReader> T setDefaultValue(float defaultValue) {
        if (!this.attribute.isMultiplicative()) {
            this.defaultValue = defaultValue;
        }
        return (T)this;
    }

    @Override
    public double getDefaultValue(PlayerAttributeMap statMap, EntityPlayer player, Side side) {
        return this.defaultValue;
    }

    @Override
    public double getModifierValueForMode(PlayerAttributeMap statMap, EntityPlayer player, Side side, PerkAttributeModifier.Mode mode) {
        double value = statMap.getModifier(player, ResearchManager.getProgress(player, side), this.attribute.getTypeString(), mode);
        if (mode == PerkAttributeModifier.Mode.ADDITION) {
            value /= 100.0;
            value += 1.0;
        }
        return value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PerkStatistic getStatistics(PlayerAttributeMap statMap, EntityPlayer player) {
        Float limit = AttributeTypeLimiter.INSTANCE.getMaxLimit(this.attribute);
        String limitStr = limit == null ? "" : I18n.func_135052_a((String)"perk.reader.limit.percent", (Object[])new Object[]{MathHelper.func_76141_d((float)(limit.floatValue() * 100.0f))});
        double value = statMap.modifyValue(player, ResearchManager.getProgress(player, Side.CLIENT), this.attribute.getTypeString(), (float)this.getDefaultValue(statMap, player, Side.CLIENT));
        if (this.attribute.isMultiplicative()) {
            value -= 1.0;
        }
        String postProcess = "";
        double postValue = AttributeEvent.postProcessModded(player, this.attribute, value);
        if (Math.abs(value - postValue) > 1.0E-4 && (limit == null || Math.abs(postValue - (double)limit.floatValue()) > 1.0E-4)) {
            if (Math.abs(postValue) >= 1.0E-4) {
                postProcess = I18n.func_135052_a((String)"perk.reader.postprocess.default", (Object[])new Object[]{(postValue >= 0.0 ? "+" : "") + AddedPercentageAttributeReader.formatDecimal(postValue) + "%"});
            }
            value = postValue;
        }
        String strOut = (value >= 0.0 ? "+" : "") + AddedPercentageAttributeReader.formatDecimal(value) + "%";
        return new PerkStatistic(this.attribute, strOut, limitStr, postProcess);
    }
}

