/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyBleed
extends KeyPerk {
    private int bleedDuration = 60;
    private float bleedChance = 0.25f;

    public KeyBleed(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyBleed.this.bleedDuration = cfg.getInt("BleedDuration", this.getConfigurationSection(), KeyBleed.this.bleedDuration, 5, 400, "Defines the duration of the bleeding effect when applied. Refreshes this duration when a it is applied again");
                KeyBleed.this.bleedChance = cfg.getFloat("BleedChance", this.getConfigurationSection(), KeyBleed.this.bleedChance, 0.01f, 1.0f, "Defines the base chance a bleed can/is applied when an entity is being hit by this entity");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.bleedDuration = MathHelper.func_76143_f((double)((double)this.bleedDuration * multiplier));
        this.bleedChance = (float)((double)this.bleedChance * multiplier);
    }

    @SubscribeEvent
    public void onAttack(LivingHurtEvent event) {
        Side side;
        EntityPlayer player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (prog = ResearchManager.getProgress(player = (EntityPlayer)source.func_76346_g(), side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)).hasPerkEffect(this)) {
            EntityLivingBase target = event.getEntityLiving();
            float chance = this.bleedChance;
            chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.bleedchance", chance);
            if (rand.nextFloat() < chance) {
                PotionEffect pe;
                int stackCap = 3;
                stackCap = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.bleedamount", stackCap));
                int duration = this.bleedDuration;
                duration = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.bleedduration", duration));
                int setAmplifier = 0;
                if (target.func_70644_a((Potion)RegistryPotions.potionBleed) && (pe = target.func_70660_b((Potion)RegistryPotions.potionBleed)) != null) {
                    setAmplifier = Math.min(pe.func_76458_c() + 1, stackCap - 1);
                }
                target.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionBleed, duration, setAmplifier, false, true));
            }
        }
    }
}

