/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyCleanseBadPotions
extends KeyPerk {
    private static final Random rand = new Random();

    public KeyCleanseBadPotions(String name, int x, int y) {
        super(name, x, y);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHeal(LivingHealEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            List badEffects = player.func_70651_bq().stream().filter(p -> p.func_188419_a().func_76398_f()).collect(Collectors.toList());
            if (badEffects.isEmpty()) {
                return;
            }
            PotionEffect effect = (PotionEffect)badEffects.get(rand.nextInt(badEffects.size()));
            PlayerProgress prog = ResearchManager.getProgress(player, Side.SERVER);
            if (prog.hasPerkEffect(this)) {
                float inclChance = 0.1f;
                inclChance = PerkAttributeHelper.getOrCreateMap(player, Side.SERVER).modifyValue(player, prog, "astralsorcery.perkeffect", inclChance);
                float chance = this.getChance(event.getAmount()) * inclChance;
                if (rand.nextFloat() < chance) {
                    player.func_184589_d(effect.func_188419_a());
                }
            }
        }
    }

    private float getChance(float healed) {
        if (healed <= 0.0f) {
            return 0.0f;
        }
        float chance = (3.0f / (healed * -0.6666667f) + 5.0f) / 5.0f;
        return MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
    }
}

