/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyDisarm
extends KeyPerk {
    private float dropChance = 0.05f;

    public KeyDisarm(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyDisarm.this.dropChance = cfg.getFloat("DropChance", this.getConfigurationSection(), KeyDisarm.this.dropChance, 0.0f, 1.0f, "Defines the chance (in percent) per hit to make the attacked entity drop its armor.");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.dropChance = (float)((double)this.dropChance * multiplier);
    }

    @SubscribeEvent
    public void onAttack(LivingHurtEvent event) {
        Side side;
        EntityPlayer player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (prog = ResearchManager.getProgress(player = (EntityPlayer)source.func_76346_g(), side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)).hasPerkEffect(this)) {
            float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.perkeffect", this.dropChance);
            float currentChance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                EntityLivingBase attacked;
                ItemStack stack;
                if (rand.nextFloat() >= currentChance || (stack = (attacked = event.getEntityLiving()).func_184582_a(slot)).func_190926_b()) continue;
                attacked.func_184201_a(slot, ItemStack.field_190927_a);
                ItemUtils.dropItemNaturally(attacked.field_70170_p, attacked.field_70165_t, attacked.field_70163_u, attacked.field_70161_v, stack);
                break;
            }
        }
    }
}

