/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.ShapedLightProximityRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractRecipeAccessor;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.BasePlainRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ShapedRecipe
extends AbstractRecipeAccessor {
    private final ShapeMap rawShapeMap;

    private ShapedRecipe(@Nonnull ItemStack output, ShapeMap rawShapeMap) {
        super(output);
        this.rawShapeMap = rawShapeMap;
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(int row, int column) {
        ShapedRecipeSlot slot = ShapedRecipeSlot.getByRowColumnIndex(row, column);
        return slot == null ? null : (ItemHandle)this.rawShapeMap.get((Object)slot);
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(ShapedRecipeSlot slot) {
        return (ItemHandle)this.rawShapeMap.get((Object)slot);
    }

    public static class Builder {
        private boolean registered = false;
        private final ResourceLocation entry;
        private final ItemStack output;
        protected ShapeMap crafingShape = new ShapeMap();

        private Builder(String name, ItemStack output) {
            this.entry = new ResourceLocation("astralsorcery", "shaped/" + name);
            this.output = ItemUtils.copyStackWithSize(output, output.func_190916_E());
        }

        public static Builder newShapedRecipe(String name, Block output) {
            return Builder.newShapedRecipe(name, new ItemStack(output));
        }

        public static Builder newShapedRecipe(String name, Item output) {
            return Builder.newShapedRecipe(name, new ItemStack(output));
        }

        public static Builder newShapedRecipe(String name, ItemStack output) {
            return new Builder(name, output);
        }

        public Builder addPart(Block block, ShapedRecipeSlot ... slots) {
            return this.addPart(new ItemStack(block), slots);
        }

        public Builder addPart(Item stack, ShapedRecipeSlot ... slots) {
            return this.addPart(new ItemStack(stack), slots);
        }

        public Builder addPart(ItemStack stack, ShapedRecipeSlot ... slots) {
            ItemHandle handle = new ItemHandle(stack);
            for (ShapedRecipeSlot slot : slots) {
                this.crafingShape.put(slot, handle);
            }
            return this;
        }

        public Builder addPart(FluidStack fluidStack, ShapedRecipeSlot ... slots) {
            ItemHandle handle = new ItemHandle(fluidStack);
            for (ShapedRecipeSlot slot : slots) {
                this.crafingShape.put(slot, handle);
            }
            return this;
        }

        public Builder addPart(Fluid fluid, int mbAmount, ShapedRecipeSlot ... slots) {
            return this.addPart(new FluidStack(fluid, mbAmount), slots);
        }

        public Builder addPart(Fluid fluid, ShapedRecipeSlot ... slots) {
            return this.addPart(fluid, 1000, slots);
        }

        public Builder addPart(String oreDictName, ShapedRecipeSlot ... slots) {
            ItemHandle handle = new ItemHandle(oreDictName);
            for (ShapedRecipeSlot slot : slots) {
                this.crafingShape.put(slot, handle);
            }
            return this;
        }

        public Builder addPart(ItemHandle handle, ShapedRecipeSlot ... slots) {
            for (ShapedRecipeSlot slot : slots) {
                this.crafingShape.put(slot, handle);
            }
            return this;
        }

        public Builder forceEmptySpaces() {
            this.crafingShape.setCut(false);
            return this;
        }

        public AccessibleRecipeAdapater unregisteredAccessibleShapedRecipe() {
            if (this.registered) {
                throw new IllegalArgumentException("Tried to register previously built recipe twice!");
            }
            this.registered = true;
            BasePlainRecipe actual = RecipeHelper.getShapedOredictRecipe(this.entry, this.output, this.crafingShape.bake());
            ShapedRecipe access = new ShapedRecipe(this.output, this.crafingShape);
            return new AccessibleRecipeAdapater(actual, access);
        }

        public AccessibleRecipeAdapater buildAndRegisterLightCraftingRecipe() {
            if (this.registered) {
                throw new IllegalArgumentException("Tried to register previously built recipe twice!");
            }
            this.registered = true;
            ShapedLightProximityRecipe actual = new ShapedLightProximityRecipe(this.entry, this.output, this.crafingShape.bake());
            CommonProxy.registryPrimer.register(actual);
            ShapedRecipe access = new ShapedRecipe(this.output, this.crafingShape);
            return new AccessibleRecipeAdapater(actual, access);
        }

        public AccessibleRecipeAdapater buildAndRegisterShapedRecipe() {
            if (this.registered) {
                throw new IllegalArgumentException("Tried to register previously built recipe twice!");
            }
            this.registered = true;
            BasePlainRecipe actual = RecipeHelper.getShapedOredictRecipe(this.entry, this.output, this.crafingShape.bake());
            CommonProxy.registryPrimer.register(actual);
            ShapedRecipe access = new ShapedRecipe(this.output, this.crafingShape);
            return new AccessibleRecipeAdapater(actual, access);
        }
    }
}

